/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.AssetDimensions;
import com.commercetools.history.models.common.AssetDimensionsBuilder;
import com.commercetools.history.models.common.AssetSource;
import com.commercetools.history.models.common.AssetSourceImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class AssetSourceBuilder
implements Builder<AssetSource> {
    private String uri;
    private String key;
    private AssetDimensions dimensions;
    private String contentType;

    public AssetSourceBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public AssetSourceBuilder key(String key) {
        this.key = key;
        return this;
    }

    public AssetSourceBuilder dimensions(Function<AssetDimensionsBuilder, AssetDimensionsBuilder> builder) {
        this.dimensions = builder.apply(AssetDimensionsBuilder.of()).build();
        return this;
    }

    public AssetSourceBuilder dimensions(AssetDimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public AssetSourceBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public String getKey() {
        return this.key;
    }

    public AssetDimensions getDimensions() {
        return this.dimensions;
    }

    public String getContentType() {
        return this.contentType;
    }

    public AssetSource build() {
        Objects.requireNonNull(this.uri, AssetSource.class + ": uri is missing");
        Objects.requireNonNull(this.key, AssetSource.class + ": key is missing");
        Objects.requireNonNull(this.dimensions, AssetSource.class + ": dimensions is missing");
        Objects.requireNonNull(this.contentType, AssetSource.class + ": contentType is missing");
        return new AssetSourceImpl(this.uri, this.key, this.dimensions, this.contentType);
    }

    public AssetSource buildUnchecked() {
        return new AssetSourceImpl(this.uri, this.key, this.dimensions, this.contentType);
    }

    public static AssetSourceBuilder of() {
        return new AssetSourceBuilder();
    }

    public static AssetSourceBuilder of(AssetSource template) {
        AssetSourceBuilder builder = new AssetSourceBuilder();
        builder.uri = template.getUri();
        builder.key = template.getKey();
        builder.dimensions = template.getDimensions();
        builder.contentType = template.getContentType();
        return builder;
    }
}

