/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.DiscountedLineItemPortion;
import com.commercetools.history.models.common.DiscountedLineItemPortionBuilder;
import com.commercetools.history.models.common.DiscountedLineItemPrice;
import com.commercetools.history.models.common.DiscountedLineItemPriceImpl;
import com.commercetools.history.models.common.Money;
import com.commercetools.history.models.common.MoneyBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class DiscountedLineItemPriceBuilder
implements Builder<DiscountedLineItemPrice> {
    private Money value;
    private List<DiscountedLineItemPortion> includedDiscounts;

    public DiscountedLineItemPriceBuilder value(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.value = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public DiscountedLineItemPriceBuilder value(Money value) {
        this.value = value;
        return this;
    }

    public DiscountedLineItemPriceBuilder includedDiscounts(DiscountedLineItemPortion ... includedDiscounts) {
        this.includedDiscounts = new ArrayList<DiscountedLineItemPortion>(Arrays.asList(includedDiscounts));
        return this;
    }

    public DiscountedLineItemPriceBuilder includedDiscounts(List<DiscountedLineItemPortion> includedDiscounts) {
        this.includedDiscounts = includedDiscounts;
        return this;
    }

    public DiscountedLineItemPriceBuilder plusIncludedDiscounts(DiscountedLineItemPortion ... includedDiscounts) {
        if (this.includedDiscounts == null) {
            this.includedDiscounts = new ArrayList<DiscountedLineItemPortion>();
        }
        this.includedDiscounts.addAll(Arrays.asList(includedDiscounts));
        return this;
    }

    public DiscountedLineItemPriceBuilder plusIncludedDiscounts(Function<DiscountedLineItemPortionBuilder, DiscountedLineItemPortionBuilder> builder) {
        if (this.includedDiscounts == null) {
            this.includedDiscounts = new ArrayList<DiscountedLineItemPortion>();
        }
        this.includedDiscounts.add(builder.apply(DiscountedLineItemPortionBuilder.of()).build());
        return this;
    }

    public DiscountedLineItemPriceBuilder withIncludedDiscounts(Function<DiscountedLineItemPortionBuilder, DiscountedLineItemPortionBuilder> builder) {
        this.includedDiscounts = new ArrayList<DiscountedLineItemPortion>();
        this.includedDiscounts.add(builder.apply(DiscountedLineItemPortionBuilder.of()).build());
        return this;
    }

    public Money getValue() {
        return this.value;
    }

    public List<DiscountedLineItemPortion> getIncludedDiscounts() {
        return this.includedDiscounts;
    }

    public DiscountedLineItemPrice build() {
        Objects.requireNonNull(this.value, DiscountedLineItemPrice.class + ": value is missing");
        Objects.requireNonNull(this.includedDiscounts, DiscountedLineItemPrice.class + ": includedDiscounts is missing");
        return new DiscountedLineItemPriceImpl(this.value, this.includedDiscounts);
    }

    public DiscountedLineItemPrice buildUnchecked() {
        return new DiscountedLineItemPriceImpl(this.value, this.includedDiscounts);
    }

    public static DiscountedLineItemPriceBuilder of() {
        return new DiscountedLineItemPriceBuilder();
    }

    public static DiscountedLineItemPriceBuilder of(DiscountedLineItemPrice template) {
        DiscountedLineItemPriceBuilder builder = new DiscountedLineItemPriceBuilder();
        builder.value = template.getValue();
        builder.includedDiscounts = template.getIncludedDiscounts();
        return builder;
    }
}

