/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Money;
import com.commercetools.history.models.common.MoneyBuilder;
import com.commercetools.history.models.common.TaxedItemPrice;
import com.commercetools.history.models.common.TaxedItemPriceImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class TaxedItemPriceBuilder
implements Builder<TaxedItemPrice> {
    private Money totalNet;
    private Money totalGross;

    public TaxedItemPriceBuilder totalNet(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.totalNet = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public TaxedItemPriceBuilder totalNet(Money totalNet) {
        this.totalNet = totalNet;
        return this;
    }

    public TaxedItemPriceBuilder totalGross(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.totalGross = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public TaxedItemPriceBuilder totalGross(Money totalGross) {
        this.totalGross = totalGross;
        return this;
    }

    public Money getTotalNet() {
        return this.totalNet;
    }

    public Money getTotalGross() {
        return this.totalGross;
    }

    public TaxedItemPrice build() {
        Objects.requireNonNull(this.totalNet, TaxedItemPrice.class + ": totalNet is missing");
        Objects.requireNonNull(this.totalGross, TaxedItemPrice.class + ": totalGross is missing");
        return new TaxedItemPriceImpl(this.totalNet, this.totalGross);
    }

    public TaxedItemPrice buildUnchecked() {
        return new TaxedItemPriceImpl(this.totalNet, this.totalGross);
    }

    public static TaxedItemPriceBuilder of() {
        return new TaxedItemPriceBuilder();
    }

    public static TaxedItemPriceBuilder of(TaxedItemPrice template) {
        TaxedItemPriceBuilder builder = new TaxedItemPriceBuilder();
        builder.totalNet = template.getTotalNet();
        builder.totalGross = template.getTotalGross();
        return builder;
    }
}

