/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Money;
import com.commercetools.history.models.common.MoneyBuilder;
import com.commercetools.history.models.common.Transaction;
import com.commercetools.history.models.common.TransactionImpl;
import com.commercetools.history.models.common.TransactionState;
import com.commercetools.history.models.common.TransactionType;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class TransactionBuilder
implements Builder<Transaction> {
    private String id;
    private String timestamp;
    private TransactionType type;
    private Money amount;
    private String interactionId;
    private TransactionState state;

    public TransactionBuilder id(String id) {
        this.id = id;
        return this;
    }

    public TransactionBuilder timestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public TransactionBuilder type(TransactionType type) {
        this.type = type;
        return this;
    }

    public TransactionBuilder amount(Function<MoneyBuilder, MoneyBuilder> builder) {
        this.amount = builder.apply(MoneyBuilder.of()).build();
        return this;
    }

    public TransactionBuilder amount(Money amount) {
        this.amount = amount;
        return this;
    }

    public TransactionBuilder interactionId(String interactionId) {
        this.interactionId = interactionId;
        return this;
    }

    public TransactionBuilder state(TransactionState state) {
        this.state = state;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public TransactionType getType() {
        return this.type;
    }

    public Money getAmount() {
        return this.amount;
    }

    public String getInteractionId() {
        return this.interactionId;
    }

    public TransactionState getState() {
        return this.state;
    }

    public Transaction build() {
        Objects.requireNonNull(this.id, Transaction.class + ": id is missing");
        Objects.requireNonNull(this.timestamp, Transaction.class + ": timestamp is missing");
        Objects.requireNonNull(this.type, Transaction.class + ": type is missing");
        Objects.requireNonNull(this.amount, Transaction.class + ": amount is missing");
        Objects.requireNonNull(this.interactionId, Transaction.class + ": interactionId is missing");
        Objects.requireNonNull(this.state, Transaction.class + ": state is missing");
        return new TransactionImpl(this.id, this.timestamp, this.type, this.amount, this.interactionId, this.state);
    }

    public Transaction buildUnchecked() {
        return new TransactionImpl(this.id, this.timestamp, this.type, this.amount, this.interactionId, this.state);
    }

    public static TransactionBuilder of() {
        return new TransactionBuilder();
    }

    public static TransactionBuilder of(Transaction template) {
        TransactionBuilder builder = new TransactionBuilder();
        builder.id = template.getId();
        builder.timestamp = template.getTimestamp();
        builder.type = template.getType();
        builder.amount = template.getAmount();
        builder.interactionId = template.getInteractionId();
        builder.state = template.getState();
        return builder;
    }
}

