/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Address;
import com.commercetools.history.models.common.AddressBuilder;
import com.commercetools.history.models.common.CustomFields;
import com.commercetools.history.models.common.CustomFieldsBuilder;
import com.commercetools.history.models.common.Delivery;
import com.commercetools.history.models.common.DeliveryImpl;
import com.commercetools.history.models.common.DeliveryItem;
import com.commercetools.history.models.common.DeliveryItemBuilder;
import com.commercetools.history.models.common.Parcel;
import com.commercetools.history.models.common.ParcelBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class DeliveryBuilder
implements Builder<Delivery> {
    private String id;
    private String createdAt;
    private List<DeliveryItem> items;
    private List<Parcel> parcels;
    @Nullable
    private Address address;
    @Nullable
    private CustomFields custom;

    public DeliveryBuilder id(String id) {
        this.id = id;
        return this;
    }

    public DeliveryBuilder createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public DeliveryBuilder items(DeliveryItem ... items) {
        this.items = new ArrayList<DeliveryItem>(Arrays.asList(items));
        return this;
    }

    public DeliveryBuilder items(List<DeliveryItem> items) {
        this.items = items;
        return this;
    }

    public DeliveryBuilder plusItems(DeliveryItem ... items) {
        if (this.items == null) {
            this.items = new ArrayList<DeliveryItem>();
        }
        this.items.addAll(Arrays.asList(items));
        return this;
    }

    public DeliveryBuilder plusItems(Function<DeliveryItemBuilder, DeliveryItemBuilder> builder) {
        if (this.items == null) {
            this.items = new ArrayList<DeliveryItem>();
        }
        this.items.add(builder.apply(DeliveryItemBuilder.of()).build());
        return this;
    }

    public DeliveryBuilder withItems(Function<DeliveryItemBuilder, DeliveryItemBuilder> builder) {
        this.items = new ArrayList<DeliveryItem>();
        this.items.add(builder.apply(DeliveryItemBuilder.of()).build());
        return this;
    }

    public DeliveryBuilder parcels(Parcel ... parcels) {
        this.parcels = new ArrayList<Parcel>(Arrays.asList(parcels));
        return this;
    }

    public DeliveryBuilder parcels(List<Parcel> parcels) {
        this.parcels = parcels;
        return this;
    }

    public DeliveryBuilder plusParcels(Parcel ... parcels) {
        if (this.parcels == null) {
            this.parcels = new ArrayList<Parcel>();
        }
        this.parcels.addAll(Arrays.asList(parcels));
        return this;
    }

    public DeliveryBuilder plusParcels(Function<ParcelBuilder, ParcelBuilder> builder) {
        if (this.parcels == null) {
            this.parcels = new ArrayList<Parcel>();
        }
        this.parcels.add(builder.apply(ParcelBuilder.of()).build());
        return this;
    }

    public DeliveryBuilder withParcels(Function<ParcelBuilder, ParcelBuilder> builder) {
        this.parcels = new ArrayList<Parcel>();
        this.parcels.add(builder.apply(ParcelBuilder.of()).build());
        return this;
    }

    public DeliveryBuilder address(Function<AddressBuilder, AddressBuilder> builder) {
        this.address = builder.apply(AddressBuilder.of()).build();
        return this;
    }

    public DeliveryBuilder address(@Nullable Address address) {
        this.address = address;
        return this;
    }

    public DeliveryBuilder custom(Function<CustomFieldsBuilder, CustomFieldsBuilder> builder) {
        this.custom = builder.apply(CustomFieldsBuilder.of()).build();
        return this;
    }

    public DeliveryBuilder custom(@Nullable CustomFields custom) {
        this.custom = custom;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public List<DeliveryItem> getItems() {
        return this.items;
    }

    public List<Parcel> getParcels() {
        return this.parcels;
    }

    @Nullable
    public Address getAddress() {
        return this.address;
    }

    @Nullable
    public CustomFields getCustom() {
        return this.custom;
    }

    public Delivery build() {
        Objects.requireNonNull(this.id, Delivery.class + ": id is missing");
        Objects.requireNonNull(this.createdAt, Delivery.class + ": createdAt is missing");
        Objects.requireNonNull(this.items, Delivery.class + ": items is missing");
        Objects.requireNonNull(this.parcels, Delivery.class + ": parcels is missing");
        return new DeliveryImpl(this.id, this.createdAt, this.items, this.parcels, this.address, this.custom);
    }

    public Delivery buildUnchecked() {
        return new DeliveryImpl(this.id, this.createdAt, this.items, this.parcels, this.address, this.custom);
    }

    public static DeliveryBuilder of() {
        return new DeliveryBuilder();
    }

    public static DeliveryBuilder of(Delivery template) {
        DeliveryBuilder builder = new DeliveryBuilder();
        builder.id = template.getId();
        builder.createdAt = template.getCreatedAt();
        builder.items = template.getItems();
        builder.parcels = template.getParcels();
        builder.address = template.getAddress();
        builder.custom = template.getCustom();
        return builder;
    }
}

