/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.common;

import com.commercetools.history.models.common.Image;
import com.commercetools.history.models.common.ImageDimensions;
import com.commercetools.history.models.common.ImageDimensionsBuilder;
import com.commercetools.history.models.common.ImageImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class ImageBuilder
implements Builder<Image> {
    private String url;
    private ImageDimensions dimensions;
    private String label;

    public ImageBuilder url(String url) {
        this.url = url;
        return this;
    }

    public ImageBuilder dimensions(Function<ImageDimensionsBuilder, ImageDimensionsBuilder> builder) {
        this.dimensions = builder.apply(ImageDimensionsBuilder.of()).build();
        return this;
    }

    public ImageBuilder dimensions(ImageDimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public ImageBuilder label(String label) {
        this.label = label;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public ImageDimensions getDimensions() {
        return this.dimensions;
    }

    public String getLabel() {
        return this.label;
    }

    public Image build() {
        Objects.requireNonNull(this.url, Image.class + ": url is missing");
        Objects.requireNonNull(this.dimensions, Image.class + ": dimensions is missing");
        Objects.requireNonNull(this.label, Image.class + ": label is missing");
        return new ImageImpl(this.url, this.dimensions, this.label);
    }

    public Image buildUnchecked() {
        return new ImageImpl(this.url, this.dimensions, this.label);
    }

    public static ImageBuilder of() {
        return new ImageBuilder();
    }

    public static ImageBuilder of(Image template) {
        ImageBuilder builder = new ImageBuilder();
        builder.url = template.getUrl();
        builder.dimensions = template.getDimensions();
        builder.label = template.getLabel();
        return builder;
    }
}

