/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.history.models.label;

import com.commercetools.history.models.common.Reference;
import com.commercetools.history.models.common.ReferenceBuilder;
import com.commercetools.history.models.label.QuoteLabel;
import com.commercetools.history.models.label.QuoteLabelImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class QuoteLabelBuilder
implements Builder<QuoteLabel> {
    private String key;
    private Reference customer;
    private Reference stagedQuote;
    private Reference quoteRequest;

    public QuoteLabelBuilder key(String key) {
        this.key = key;
        return this;
    }

    public QuoteLabelBuilder customer(Function<ReferenceBuilder, ReferenceBuilder> builder) {
        this.customer = builder.apply(ReferenceBuilder.of()).build();
        return this;
    }

    public QuoteLabelBuilder customer(Reference customer) {
        this.customer = customer;
        return this;
    }

    public QuoteLabelBuilder stagedQuote(Function<ReferenceBuilder, ReferenceBuilder> builder) {
        this.stagedQuote = builder.apply(ReferenceBuilder.of()).build();
        return this;
    }

    public QuoteLabelBuilder stagedQuote(Reference stagedQuote) {
        this.stagedQuote = stagedQuote;
        return this;
    }

    public QuoteLabelBuilder quoteRequest(Function<ReferenceBuilder, ReferenceBuilder> builder) {
        this.quoteRequest = builder.apply(ReferenceBuilder.of()).build();
        return this;
    }

    public QuoteLabelBuilder quoteRequest(Reference quoteRequest) {
        this.quoteRequest = quoteRequest;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Reference getCustomer() {
        return this.customer;
    }

    public Reference getStagedQuote() {
        return this.stagedQuote;
    }

    public Reference getQuoteRequest() {
        return this.quoteRequest;
    }

    public QuoteLabel build() {
        Objects.requireNonNull(this.key, QuoteLabel.class + ": key is missing");
        Objects.requireNonNull(this.customer, QuoteLabel.class + ": customer is missing");
        Objects.requireNonNull(this.stagedQuote, QuoteLabel.class + ": stagedQuote is missing");
        Objects.requireNonNull(this.quoteRequest, QuoteLabel.class + ": quoteRequest is missing");
        return new QuoteLabelImpl(this.key, this.customer, this.stagedQuote, this.quoteRequest);
    }

    public QuoteLabel buildUnchecked() {
        return new QuoteLabelImpl(this.key, this.customer, this.stagedQuote, this.quoteRequest);
    }

    public static QuoteLabelBuilder of() {
        return new QuoteLabelBuilder();
    }

    public static QuoteLabelBuilder of(QuoteLabel template) {
        QuoteLabelBuilder builder = new QuoteLabelBuilder();
        builder.key = template.getKey();
        builder.customer = template.getCustomer();
        builder.stagedQuote = template.getStagedQuote();
        builder.quoteRequest = template.getQuoteRequest();
        return builder;
    }
}

