/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.client;

import com.commercetools.ml.client.ApiRoot;
import com.commercetools.ml.client.ByProjectKeyImageSearchRequestBuilder;
import com.commercetools.ml.client.ByProjectKeyRecommendationsRequestBuilder;
import com.commercetools.ml.client.ByProjectKeyRequestBuilder;
import com.commercetools.ml.client.ByProjectKeySimilaritiesRequestBuilder;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.SerializerOnlyApiHttpClient;
import java.io.Closeable;

public class ProjectApiRoot
implements Closeable {
    private final String projectKey;
    private final ApiHttpClient apiHttpClient;

    private ProjectApiRoot(String projectKey, ApiHttpClient apiHttpClient) {
        this.projectKey = projectKey;
        this.apiHttpClient = apiHttpClient;
    }

    public static ProjectApiRoot of(String projectKey) {
        return new ProjectApiRoot(projectKey, (ApiHttpClient)SerializerOnlyApiHttpClient.of());
    }

    public static ProjectApiRoot fromClient(String projectKey, ApiHttpClient apiHttpClient) {
        return new ProjectApiRoot(projectKey, apiHttpClient);
    }

    public ByProjectKeyRequestBuilder with() {
        return ApiRoot.fromClient(this.apiHttpClient).withProjectKey(this.projectKey);
    }

    public ByProjectKeyRequestBuilder withProjectKey(String projectKey) {
        return ApiRoot.fromClient(this.apiHttpClient).withProjectKey(projectKey);
    }

    public ByProjectKeyImageSearchRequestBuilder imageSearch() {
        return this.with().imageSearch();
    }

    public ByProjectKeyRecommendationsRequestBuilder recommendations() {
        return this.with().recommendations();
    }

    public ByProjectKeySimilaritiesRequestBuilder similarities() {
        return this.with().similarities();
    }

    @Override
    public void close() {
        if (this.apiHttpClient == null) {
            return;
        }
        try {
            this.apiHttpClient.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

