/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.image_search;

import com.commercetools.ml.models.common.ProductVariant;
import com.commercetools.ml.models.common.ProductVariantBuilder;
import com.commercetools.ml.models.image_search.ResultItem;
import com.commercetools.ml.models.image_search.ResultItemImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class ResultItemBuilder
implements Builder<ResultItem> {
    private String imageUrl;
    private List<ProductVariant> productVariants;

    public ResultItemBuilder imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public ResultItemBuilder productVariants(ProductVariant ... productVariants) {
        this.productVariants = new ArrayList<ProductVariant>(Arrays.asList(productVariants));
        return this;
    }

    public ResultItemBuilder productVariants(List<ProductVariant> productVariants) {
        this.productVariants = productVariants;
        return this;
    }

    public ResultItemBuilder plusProductVariants(ProductVariant ... productVariants) {
        if (this.productVariants == null) {
            this.productVariants = new ArrayList<ProductVariant>();
        }
        this.productVariants.addAll(Arrays.asList(productVariants));
        return this;
    }

    public ResultItemBuilder plusProductVariants(Function<ProductVariantBuilder, ProductVariantBuilder> builder) {
        if (this.productVariants == null) {
            this.productVariants = new ArrayList<ProductVariant>();
        }
        this.productVariants.add(builder.apply(ProductVariantBuilder.of()).build());
        return this;
    }

    public ResultItemBuilder withProductVariants(Function<ProductVariantBuilder, ProductVariantBuilder> builder) {
        this.productVariants = new ArrayList<ProductVariant>();
        this.productVariants.add(builder.apply(ProductVariantBuilder.of()).build());
        return this;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public List<ProductVariant> getProductVariants() {
        return this.productVariants;
    }

    public ResultItem build() {
        Objects.requireNonNull(this.imageUrl, ResultItem.class + ": imageUrl is missing");
        Objects.requireNonNull(this.productVariants, ResultItem.class + ": productVariants is missing");
        return new ResultItemImpl(this.imageUrl, this.productVariants);
    }

    public ResultItem buildUnchecked() {
        return new ResultItemImpl(this.imageUrl, this.productVariants);
    }

    public static ResultItemBuilder of() {
        return new ResultItemBuilder();
    }

    public static ResultItemBuilder of(ResultItem template) {
        ResultItemBuilder builder = new ResultItemBuilder();
        builder.imageUrl = template.getImageUrl();
        builder.productVariants = template.getProductVariants();
        return builder;
    }
}

