/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.similar_products;

import com.commercetools.ml.models.common.ProductReference;
import com.commercetools.ml.models.common.ProductReferenceBuilder;
import com.commercetools.ml.models.similar_products.SimilarProduct;
import com.commercetools.ml.models.similar_products.SimilarProductImpl;
import com.commercetools.ml.models.similar_products.SimilarProductMeta;
import com.commercetools.ml.models.similar_products.SimilarProductMetaBuilder;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.function.Function;
import javax.annotation.Nullable;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class SimilarProductBuilder
implements Builder<SimilarProduct> {
    @Nullable
    private ProductReference product;
    @Nullable
    private Long variantId;
    @Nullable
    private SimilarProductMeta meta;

    public SimilarProductBuilder product(Function<ProductReferenceBuilder, ProductReferenceBuilder> builder) {
        this.product = builder.apply(ProductReferenceBuilder.of()).build();
        return this;
    }

    public SimilarProductBuilder withProduct(Function<ProductReferenceBuilder, ProductReference> builder) {
        this.product = builder.apply(ProductReferenceBuilder.of());
        return this;
    }

    public SimilarProductBuilder product(@Nullable ProductReference product) {
        this.product = product;
        return this;
    }

    public SimilarProductBuilder variantId(@Nullable Long variantId) {
        this.variantId = variantId;
        return this;
    }

    public SimilarProductBuilder meta(Function<SimilarProductMetaBuilder, SimilarProductMetaBuilder> builder) {
        this.meta = builder.apply(SimilarProductMetaBuilder.of()).build();
        return this;
    }

    public SimilarProductBuilder withMeta(Function<SimilarProductMetaBuilder, SimilarProductMeta> builder) {
        this.meta = builder.apply(SimilarProductMetaBuilder.of());
        return this;
    }

    public SimilarProductBuilder meta(@Nullable SimilarProductMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    public ProductReference getProduct() {
        return this.product;
    }

    @Nullable
    public Long getVariantId() {
        return this.variantId;
    }

    @Nullable
    public SimilarProductMeta getMeta() {
        return this.meta;
    }

    public SimilarProduct build() {
        return new SimilarProductImpl(this.product, this.variantId, this.meta);
    }

    public SimilarProduct buildUnchecked() {
        return new SimilarProductImpl(this.product, this.variantId, this.meta);
    }

    public static SimilarProductBuilder of() {
        return new SimilarProductBuilder();
    }

    public static SimilarProductBuilder of(SimilarProduct template) {
        SimilarProductBuilder builder = new SimilarProductBuilder();
        builder.product = template.getProduct();
        builder.variantId = template.getVariantId();
        builder.meta = template.getMeta();
        return builder;
    }
}

