/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.similar_products;

import com.commercetools.ml.models.similar_products.SimilarProduct;
import com.commercetools.ml.models.similar_products.SimilarProductBuilder;
import com.commercetools.ml.models.similar_products.SimilarProductPair;
import com.commercetools.ml.models.similar_products.SimilarProductPairImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendering.CoreCodeGenerator", comments="https://github.com/commercetools/rmf-codegen")
public class SimilarProductPairBuilder
implements Builder<SimilarProductPair> {
    private Double confidence;
    private List<SimilarProduct> products;

    public SimilarProductPairBuilder confidence(Double confidence) {
        this.confidence = confidence;
        return this;
    }

    public SimilarProductPairBuilder products(SimilarProduct ... products) {
        this.products = new ArrayList<SimilarProduct>(Arrays.asList(products));
        return this;
    }

    public SimilarProductPairBuilder products(List<SimilarProduct> products) {
        this.products = products;
        return this;
    }

    public SimilarProductPairBuilder plusProducts(SimilarProduct ... products) {
        if (this.products == null) {
            this.products = new ArrayList<SimilarProduct>();
        }
        this.products.addAll(Arrays.asList(products));
        return this;
    }

    public SimilarProductPairBuilder plusProducts(Function<SimilarProductBuilder, SimilarProductBuilder> builder) {
        if (this.products == null) {
            this.products = new ArrayList<SimilarProduct>();
        }
        this.products.add(builder.apply(SimilarProductBuilder.of()).build());
        return this;
    }

    public SimilarProductPairBuilder withProducts(Function<SimilarProductBuilder, SimilarProductBuilder> builder) {
        this.products = new ArrayList<SimilarProduct>();
        this.products.add(builder.apply(SimilarProductBuilder.of()).build());
        return this;
    }

    public SimilarProductPairBuilder addProducts(Function<SimilarProductBuilder, SimilarProduct> builder) {
        return this.plusProducts(builder.apply(SimilarProductBuilder.of()));
    }

    public SimilarProductPairBuilder setProducts(Function<SimilarProductBuilder, SimilarProduct> builder) {
        return this.products(builder.apply(SimilarProductBuilder.of()));
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public List<SimilarProduct> getProducts() {
        return this.products;
    }

    public SimilarProductPair build() {
        Objects.requireNonNull(this.confidence, SimilarProductPair.class + ": confidence is missing");
        Objects.requireNonNull(this.products, SimilarProductPair.class + ": products is missing");
        return new SimilarProductPairImpl(this.confidence, this.products);
    }

    public SimilarProductPair buildUnchecked() {
        return new SimilarProductPairImpl(this.confidence, this.products);
    }

    public static SimilarProductPairBuilder of() {
        return new SimilarProductPairBuilder();
    }

    public static SimilarProductPairBuilder of(SimilarProductPair template) {
        SimilarProductPairBuilder builder = new SimilarProductPairBuilder();
        builder.confidence = template.getConfidence();
        builder.products = template.getProducts();
        return builder;
    }
}

