/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.client;

import com.commercetools.ml.models.image_search.ImageSearchResponse;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ApiMethod;
import io.vrap.rmf.base.client.BodyApiMethod;
import io.vrap.rmf.base.client.utils.FileUtils;
import io.vrap.rmf.base.client.utils.Generated;
import java.io.File;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Generated(value="io.vrap.rmf.codegen.rendring.CoreCodeGenerator", comments="https://github.com/vrapio/rmf-codegen")
public class ByProjectKeyImageSearchPost
extends BodyApiMethod<ByProjectKeyImageSearchPost, ImageSearchResponse, File> {
    private String projectKey;
    private File file;

    public ByProjectKeyImageSearchPost(ApiHttpClient apiHttpClient, String projectKey, File file) {
        super(apiHttpClient);
        this.projectKey = projectKey;
        this.file = file;
    }

    public ByProjectKeyImageSearchPost(ByProjectKeyImageSearchPost t) {
        super((ApiMethod)t);
        this.projectKey = t.projectKey;
        this.file = t.file;
    }

    protected ApiHttpRequest buildHttpRequest() {
        ApiHttpHeaders headers;
        ArrayList params = new ArrayList(this.getQueryParamUriStrings());
        String httpRequestPath = String.format("/%s/image-search", this.projectKey);
        if (!params.isEmpty()) {
            httpRequestPath = httpRequestPath + "?" + String.join((CharSequence)"&", params);
        }
        if ((headers = this.getHeaders()).getFirst("Content-Type") == null) {
            String mimeType = Optional.ofNullable(URLConnection.guessContentTypeFromName(this.file.getName())).orElse("application/octet-stream");
            headers = headers.withHeader("Content-Type", mimeType);
        }
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(httpRequestPath), headers, (byte[])FileUtils.executing(() -> Files.readAllBytes(this.file.toPath())));
    }

    public ApiHttpResponse<ImageSearchResponse> executeBlocking(ApiHttpClient client, Duration timeout) {
        return this.executeBlocking(client, timeout, ImageSearchResponse.class);
    }

    public CompletableFuture<ApiHttpResponse<ImageSearchResponse>> execute(ApiHttpClient client) {
        return this.execute(client, ImageSearchResponse.class);
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public List<String> getLimit() {
        return this.getQueryParam("limit");
    }

    public List<String> getOffset() {
        return this.getQueryParam("offset");
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public ByProjectKeyImageSearchPost withLimit(int limit) {
        return (ByProjectKeyImageSearchPost)this.copy().withQueryParam("limit", limit);
    }

    public ByProjectKeyImageSearchPost addLimit(int limit) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParam("limit", limit);
    }

    public ByProjectKeyImageSearchPost withLimit(Supplier<Integer> supplier) {
        return (ByProjectKeyImageSearchPost)this.copy().withQueryParam("limit", supplier.get());
    }

    public ByProjectKeyImageSearchPost addLimit(Supplier<Integer> supplier) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParam("limit", supplier.get());
    }

    public ByProjectKeyImageSearchPost withLimit(Function<StringBuilder, StringBuilder> op) {
        return (ByProjectKeyImageSearchPost)this.copy().withQueryParam("limit", op.apply(new StringBuilder()));
    }

    public ByProjectKeyImageSearchPost addLimit(Function<StringBuilder, StringBuilder> op) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParam("limit", op.apply(new StringBuilder()));
    }

    public ByProjectKeyImageSearchPost withLimit(List<Integer> limit) {
        return (ByProjectKeyImageSearchPost)((ByProjectKeyImageSearchPost)this.copy().withoutQueryParam("limit")).addQueryParams(limit.stream().map(s -> new ApiMethod.ParamEntry((Object)"limit", (Object)s.toString())).collect(Collectors.toList()));
    }

    public ByProjectKeyImageSearchPost addLimit(List<Integer> limit) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParams(limit.stream().map(s -> new ApiMethod.ParamEntry((Object)"limit", (Object)s.toString())).collect(Collectors.toList()));
    }

    public ByProjectKeyImageSearchPost withOffset(int offset) {
        return (ByProjectKeyImageSearchPost)this.copy().withQueryParam("offset", offset);
    }

    public ByProjectKeyImageSearchPost addOffset(int offset) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParam("offset", offset);
    }

    public ByProjectKeyImageSearchPost withOffset(Supplier<Integer> supplier) {
        return (ByProjectKeyImageSearchPost)this.copy().withQueryParam("offset", supplier.get());
    }

    public ByProjectKeyImageSearchPost addOffset(Supplier<Integer> supplier) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParam("offset", supplier.get());
    }

    public ByProjectKeyImageSearchPost withOffset(Function<StringBuilder, StringBuilder> op) {
        return (ByProjectKeyImageSearchPost)this.copy().withQueryParam("offset", op.apply(new StringBuilder()));
    }

    public ByProjectKeyImageSearchPost addOffset(Function<StringBuilder, StringBuilder> op) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParam("offset", op.apply(new StringBuilder()));
    }

    public ByProjectKeyImageSearchPost withOffset(List<Integer> offset) {
        return (ByProjectKeyImageSearchPost)((ByProjectKeyImageSearchPost)this.copy().withoutQueryParam("offset")).addQueryParams(offset.stream().map(s -> new ApiMethod.ParamEntry((Object)"offset", (Object)s.toString())).collect(Collectors.toList()));
    }

    public ByProjectKeyImageSearchPost addOffset(List<Integer> offset) {
        return (ByProjectKeyImageSearchPost)this.copy().addQueryParams(offset.stream().map(s -> new ApiMethod.ParamEntry((Object)"offset", (Object)s.toString())).collect(Collectors.toList()));
    }

    public File getBody() {
        return this.file;
    }

    public ByProjectKeyImageSearchPost withBody(File file) {
        ByProjectKeyImageSearchPost t = this.copy();
        t.file = file;
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ByProjectKeyImageSearchPost that = (ByProjectKeyImageSearchPost)((Object)o);
        return new EqualsBuilder().append((Object)this.projectKey, (Object)that.projectKey).append((Object)this.file, (Object)that.file).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.projectKey).append((Object)this.file).toHashCode();
    }

    protected ByProjectKeyImageSearchPost copy() {
        return new ByProjectKeyImageSearchPost(this);
    }
}

