/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.common;

import com.commercetools.ml.models.common.ProductReference;
import com.commercetools.ml.models.common.ProductReferenceBuilder;
import com.commercetools.ml.models.common.ProductVariant;
import com.commercetools.ml.models.common.ProductVariantImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendring.CoreCodeGenerator", comments="https://github.com/vrapio/rmf-codegen")
public class ProductVariantBuilder
implements Builder<ProductVariant> {
    private ProductReference product;
    private Boolean staged;
    private Integer variantId;

    public ProductVariantBuilder product(Function<ProductReferenceBuilder, ProductReferenceBuilder> builder) {
        this.product = builder.apply(ProductReferenceBuilder.of()).build();
        return this;
    }

    public ProductVariantBuilder product(ProductReference product) {
        this.product = product;
        return this;
    }

    public ProductVariantBuilder staged(Boolean staged) {
        this.staged = staged;
        return this;
    }

    public ProductVariantBuilder variantId(Integer variantId) {
        this.variantId = variantId;
        return this;
    }

    public ProductReference getProduct() {
        return this.product;
    }

    public Boolean getStaged() {
        return this.staged;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public ProductVariant build() {
        Objects.requireNonNull(this.product, ProductVariant.class + ": product is missing");
        Objects.requireNonNull(this.staged, ProductVariant.class + ": staged is missing");
        Objects.requireNonNull(this.variantId, ProductVariant.class + ": variantId is missing");
        return new ProductVariantImpl(this.product, this.staged, this.variantId);
    }

    public ProductVariant buildUnchecked() {
        return new ProductVariantImpl(this.product, this.staged, this.variantId);
    }

    public static ProductVariantBuilder of() {
        return new ProductVariantBuilder();
    }

    public static ProductVariantBuilder of(ProductVariant template) {
        ProductVariantBuilder builder = new ProductVariantBuilder();
        builder.product = template.getProduct();
        builder.staged = template.getStaged();
        builder.variantId = template.getVariantId();
        return builder;
    }
}

