/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.missing_data;

import com.commercetools.ml.models.common.ProductReference;
import com.commercetools.ml.models.common.ProductReferenceBuilder;
import com.commercetools.ml.models.common.ProductTypeReference;
import com.commercetools.ml.models.common.ProductTypeReferenceBuilder;
import com.commercetools.ml.models.missing_data.AttributeCount;
import com.commercetools.ml.models.missing_data.AttributeCountBuilder;
import com.commercetools.ml.models.missing_data.AttributeCoverage;
import com.commercetools.ml.models.missing_data.AttributeCoverageBuilder;
import com.commercetools.ml.models.missing_data.MissingAttributes;
import com.commercetools.ml.models.missing_data.MissingAttributesImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@Generated(value="io.vrap.rmf.codegen.rendring.CoreCodeGenerator", comments="https://github.com/vrapio/rmf-codegen")
public class MissingAttributesBuilder
implements Builder<MissingAttributes> {
    private ProductReference product;
    private ProductTypeReference productType;
    private Integer variantId;
    private List<String> missingAttributeValues;
    @Nullable
    private List<String> missingAttributeNames;
    @Nullable
    private AttributeCount attributeCount;
    @Nullable
    private AttributeCoverage attributeCoverage;

    public MissingAttributesBuilder product(Function<ProductReferenceBuilder, ProductReferenceBuilder> builder) {
        this.product = builder.apply(ProductReferenceBuilder.of()).build();
        return this;
    }

    public MissingAttributesBuilder product(ProductReference product) {
        this.product = product;
        return this;
    }

    public MissingAttributesBuilder productType(Function<ProductTypeReferenceBuilder, ProductTypeReferenceBuilder> builder) {
        this.productType = builder.apply(ProductTypeReferenceBuilder.of()).build();
        return this;
    }

    public MissingAttributesBuilder productType(ProductTypeReference productType) {
        this.productType = productType;
        return this;
    }

    public MissingAttributesBuilder variantId(Integer variantId) {
        this.variantId = variantId;
        return this;
    }

    public MissingAttributesBuilder missingAttributeValues(String ... missingAttributeValues) {
        this.missingAttributeValues = new ArrayList<String>(Arrays.asList(missingAttributeValues));
        return this;
    }

    public MissingAttributesBuilder missingAttributeValues(List<String> missingAttributeValues) {
        this.missingAttributeValues = missingAttributeValues;
        return this;
    }

    public MissingAttributesBuilder missingAttributeNames(String ... missingAttributeNames) {
        this.missingAttributeNames = new ArrayList<String>(Arrays.asList(missingAttributeNames));
        return this;
    }

    public MissingAttributesBuilder missingAttributeNames(@Nullable List<String> missingAttributeNames) {
        this.missingAttributeNames = missingAttributeNames;
        return this;
    }

    public MissingAttributesBuilder attributeCount(Function<AttributeCountBuilder, AttributeCountBuilder> builder) {
        this.attributeCount = builder.apply(AttributeCountBuilder.of()).build();
        return this;
    }

    public MissingAttributesBuilder attributeCount(@Nullable AttributeCount attributeCount) {
        this.attributeCount = attributeCount;
        return this;
    }

    public MissingAttributesBuilder attributeCoverage(Function<AttributeCoverageBuilder, AttributeCoverageBuilder> builder) {
        this.attributeCoverage = builder.apply(AttributeCoverageBuilder.of()).build();
        return this;
    }

    public MissingAttributesBuilder attributeCoverage(@Nullable AttributeCoverage attributeCoverage) {
        this.attributeCoverage = attributeCoverage;
        return this;
    }

    public ProductReference getProduct() {
        return this.product;
    }

    public ProductTypeReference getProductType() {
        return this.productType;
    }

    public Integer getVariantId() {
        return this.variantId;
    }

    public List<String> getMissingAttributeValues() {
        return this.missingAttributeValues;
    }

    @Nullable
    public List<String> getMissingAttributeNames() {
        return this.missingAttributeNames;
    }

    @Nullable
    public AttributeCount getAttributeCount() {
        return this.attributeCount;
    }

    @Nullable
    public AttributeCoverage getAttributeCoverage() {
        return this.attributeCoverage;
    }

    public MissingAttributes build() {
        Objects.requireNonNull(this.product, MissingAttributes.class + ": product is missing");
        Objects.requireNonNull(this.productType, MissingAttributes.class + ": productType is missing");
        Objects.requireNonNull(this.variantId, MissingAttributes.class + ": variantId is missing");
        Objects.requireNonNull(this.missingAttributeValues, MissingAttributes.class + ": missingAttributeValues is missing");
        return new MissingAttributesImpl(this.product, this.productType, this.variantId, this.missingAttributeValues, this.missingAttributeNames, this.attributeCount, this.attributeCoverage);
    }

    public MissingAttributes buildUnchecked() {
        return new MissingAttributesImpl(this.product, this.productType, this.variantId, this.missingAttributeValues, this.missingAttributeNames, this.attributeCount, this.attributeCoverage);
    }

    public static MissingAttributesBuilder of() {
        return new MissingAttributesBuilder();
    }

    public static MissingAttributesBuilder of(MissingAttributes template) {
        MissingAttributesBuilder builder = new MissingAttributesBuilder();
        builder.product = template.getProduct();
        builder.productType = template.getProductType();
        builder.variantId = template.getVariantId();
        builder.missingAttributeValues = template.getMissingAttributeValues();
        builder.missingAttributeNames = template.getMissingAttributeNames();
        builder.attributeCount = template.getAttributeCount();
        builder.attributeCoverage = template.getAttributeCoverage();
        return builder;
    }
}

