/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.ml.models.missing_data;

import com.commercetools.ml.models.common.ProductReference;
import com.commercetools.ml.models.common.ProductReferenceBuilder;
import com.commercetools.ml.models.missing_data.MissingImages;
import com.commercetools.ml.models.missing_data.MissingImagesImpl;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.utils.Generated;
import java.util.Objects;
import java.util.function.Function;

@Generated(value="io.vrap.rmf.codegen.rendring.CoreCodeGenerator", comments="https://github.com/vrapio/rmf-codegen")
public class MissingImagesBuilder
implements Builder<MissingImages> {
    private ProductReference product;
    private Long variantId;
    private Long imageCount;

    public MissingImagesBuilder product(Function<ProductReferenceBuilder, ProductReferenceBuilder> builder) {
        this.product = builder.apply(ProductReferenceBuilder.of()).build();
        return this;
    }

    public MissingImagesBuilder product(ProductReference product) {
        this.product = product;
        return this;
    }

    public MissingImagesBuilder variantId(Long variantId) {
        this.variantId = variantId;
        return this;
    }

    public MissingImagesBuilder imageCount(Long imageCount) {
        this.imageCount = imageCount;
        return this;
    }

    public ProductReference getProduct() {
        return this.product;
    }

    public Long getVariantId() {
        return this.variantId;
    }

    public Long getImageCount() {
        return this.imageCount;
    }

    public MissingImages build() {
        Objects.requireNonNull(this.product, MissingImages.class + ": product is missing");
        Objects.requireNonNull(this.variantId, MissingImages.class + ": variantId is missing");
        Objects.requireNonNull(this.imageCount, MissingImages.class + ": imageCount is missing");
        return new MissingImagesImpl(this.product, this.variantId, this.imageCount);
    }

    public MissingImages buildUnchecked() {
        return new MissingImagesImpl(this.product, this.variantId, this.imageCount);
    }

    public static MissingImagesBuilder of() {
        return new MissingImagesBuilder();
    }

    public static MissingImagesBuilder of(MissingImages template) {
        MissingImagesBuilder builder = new MissingImagesBuilder();
        builder.product = template.getProduct();
        builder.variantId = template.getVariantId();
        builder.imageCount = template.getImageCount();
        return builder;
    }
}

