/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.http.HandlerStack;
import java.net.URI;
import java.util.concurrent.CompletableFuture;

public class ApiHttpClient
extends AutoCloseableService {
    public static final String CLOSED_MESSAGE = "Client is already closed.";
    private final HandlerStack stack;
    private final URI baseUri;
    private final ResponseSerializer serializer;

    public ApiHttpClient(String baseUri, HandlerStack stack) {
        this(URI.create(baseUri), stack);
    }

    public ApiHttpClient(URI baseUri, HandlerStack stack) {
        this(baseUri, stack, ResponseSerializer.of());
    }

    public ApiHttpClient(URI baseUri, HandlerStack stack, ResponseSerializer serializer) {
        this.stack = stack;
        this.baseUri = baseUri;
        this.serializer = serializer;
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        this.rejectExecutionIfClosed(CLOSED_MESSAGE);
        return this.stack.invoke(request.resolve(this.baseUri));
    }

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest request, Class<O> outputType) {
        return this.execute(request).thenApply(response -> this.serializer.convertResponse((ApiHttpResponse<byte[]>)response, outputType));
    }

    public ResponseSerializer getSerializerService() {
        return this.serializer;
    }

    @Override
    protected void internalClose() {
        ApiHttpClient.closeQuietly(this.stack);
    }
}

