/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.SerializationException;
import io.vrap.rmf.base.client.error.BaseException;
import io.vrap.rmf.base.client.utils.json.VrapJsonUtils;

public class ApiHttpException
extends BaseException {
    private final int statusCode;
    private final String body;
    private final ApiHttpHeaders headers;
    private final String message;
    private final ApiHttpResponse<byte[]> response;

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers) {
        this(statusCode, body, headers, null);
    }

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers, ApiHttpResponse<byte[]> response) {
        this(statusCode, body, headers, null, response);
    }

    public ApiHttpException(int statusCode, String body, ApiHttpHeaders headers, String message, ApiHttpResponse<byte[]> response) {
        super(message);
        this.statusCode = statusCode;
        this.body = body;
        this.message = message;
        this.headers = headers;
        this.response = response;
    }

    public <T> T getBodyAs(Class<T> clazz) throws SerializationException {
        try {
            return (T)VrapJsonUtils.getConfiguredObjectMapper().readValue(this.body, clazz);
        }
        catch (Exception e) {
            throw new SerializationException(e.getMessage());
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public ApiHttpResponse<byte[]> getResponse() {
        return this.response;
    }
}

