/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.Base;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ApiHttpRequest
extends Base {
    private ApiHttpMethod method;
    private URI uri;
    private ApiHttpHeaders headers;
    private byte[] body;

    public ApiHttpRequest() {
    }

    public ApiHttpRequest(ApiHttpMethod method, URI uri, ApiHttpHeaders headers, byte[] body) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.body = body;
    }

    public ApiHttpRequest(ApiHttpRequest r) {
        this.method = r.method;
        this.uri = r.uri;
        this.headers = r.headers;
        this.body = r.body;
    }

    public ApiHttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(ApiHttpMethod method) {
        this.method = method;
    }

    public ApiHttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new ApiHttpHeaders();
        }
        return this.headers;
    }

    public void setHeaders(ApiHttpHeaders headers) {
        this.headers = headers;
    }

    public ApiHttpRequest addHeader(String key, String value) {
        this.headers = this.getHeaders().addHeader(key, value);
        return this;
    }

    public ApiHttpRequest withHeader(String key, String value) {
        this.headers = this.getHeaders().withHeader(key, value);
        return this;
    }

    public ApiHttpRequest withoutHeader(String key) {
        this.headers = this.getHeaders().withoutHeader(key);
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBody(String body) {
        if (body == null) {
            this.body = null;
            return;
        }
        this.setBody(body.getBytes());
    }

    public URI getUri() {
        return this.uri;
    }

    public URL getUrl() {
        try {
            return this.uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Malformed URI", e);
        }
    }

    public void setUri(String uri) {
        this.uri = URI.create(uri);
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public ApiHttpRequest resolve(URI baseUri) {
        ApiHttpRequest request = new ApiHttpRequest(this);
        request.setUri(baseUri.resolve(this.uri));
        return request;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("method", (Object)this.method).append("uri", (Object)("\"" + this.uri + "\"")).append("headers", (Object)this.headers).append("textInterpretedBody", (Object)this.getSecuredBody()).toString();
    }

    public String getSecuredBody() {
        return Optional.ofNullable(this.body).map(b -> ApiHttpRequest.tryToFilter(new String((byte[])b, StandardCharsets.UTF_8))).orElse("empty body");
    }

    static String tryToFilter(String input) {
        return input.replaceAll("(\"\\w*([Pp]ass|access_token|refresh_token)\\w*\"):\"[^\"]*\"", "$1:\"**removed from output**\"");
    }
}

