/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApiMethod<T extends ApiMethod<T>> {
    private ApiHttpHeaders headers = new ApiHttpHeaders();
    private List<ParamEntry<String, String>> queryParams = new ArrayList<ParamEntry<String, String>>();
    private final ApiHttpClient apiHttpClient;

    protected ApiHttpClient apiHttpClient() {
        return this.apiHttpClient;
    }

    public ApiMethod(ApiHttpClient apiHttpClient) {
        this.apiHttpClient = apiHttpClient;
    }

    public ApiMethod(ApiMethod<T> apiMethod) {
        this.apiHttpClient = apiMethod.apiHttpClient;
        this.headers = new ApiHttpHeaders(apiMethod.headers);
        this.queryParams = new ArrayList<ParamEntry<String, String>>(apiMethod.queryParams);
    }

    public T addHeader(String key, String value) {
        this.headers.addHeader(key, value);
        return (T)this;
    }

    public T withoutHeader(String key) {
        this.headers.withoutHeader(key);
        return (T)this;
    }

    public T withHeader(String key, String value) {
        this.headers.withHeader(key, value);
        return (T)this;
    }

    public T withHeaders(ApiHttpHeaders headers) {
        this.headers = headers;
        return (T)this;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    public <V> T addQueryParam(String key, V value) {
        this.queryParams.add(new ParamEntry<String, String>(key, value.toString()));
        return (T)this;
    }

    public <V> T withQueryParam(String key, V value) {
        return ((ApiMethod)this.withoutQueryParam(key)).addQueryParam(key, value);
    }

    public T withoutQueryParam(String key) {
        this.queryParams = this.queryParams.stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase(key)).collect(Collectors.toList());
        return (T)this;
    }

    public <V> T withQueryParams(List<ParamEntry<String, String>> queryParams) {
        this.queryParams = queryParams;
        return (T)this;
    }

    public List<ParamEntry<String, String>> getQueryParams() {
        return this.queryParams;
    }

    public List<String> getQueryParam(String key) {
        return this.queryParams.stream().filter(e -> ((String)e.key).equals(key)).map(e -> (String)e.value).collect(Collectors.toList());
    }

    public List<String> getQueryParamUriStrings() {
        return this.queryParams.stream().map(ParamEntry::toUriString).collect(Collectors.toList());
    }

    public static class ParamEntry<K, V>
    implements Map.Entry<K, V> {
        protected final K key;
        protected V value;

        public ParamEntry(K key) {
            this.key = key;
        }

        public ParamEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toUriString() {
            try {
                return this.key + "=" + URLEncoder.encode(this.value.toString(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return "";
            }
        }
    }
}

