/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.Base;
import io.vrap.rmf.base.client.http.InternalLogger;
import java.util.function.Supplier;

public abstract class AutoCloseableService
extends Base
implements AutoCloseable {
    private boolean closed = false;

    protected AutoCloseableService() {
        this.log(() -> "Creating " + this.getLogName());
    }

    private void log(Supplier<Object> message) {
        InternalLogger.getLogger(this.getClass()).trace(message);
    }

    private String getLogName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public final synchronized void close() {
        try {
            this.internalClose();
        }
        finally {
            this.closed = true;
            this.log(() -> "Closing " + this.getLogName());
        }
    }

    protected abstract void internalClose();

    protected final boolean isClosed() {
        return this.closed;
    }

    protected void rejectExecutionIfClosed(String message) {
        if (this.isClosed()) {
            throw new IllegalStateException(message);
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            InternalLogger.getLogger(AutoCloseableService.class).error(() -> "Error on closing resource.", e);
        }
    }
}

