/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.MiddlewareFactory;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.CorrelationIdProvider;
import io.vrap.rmf.base.client.http.HandlerStack;
import io.vrap.rmf.base.client.http.HttpHandler;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class ClientFactory {
    public static final String COMMERCETOOLS = "commercetools";

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, request -> InternalLogger.getLogger(COMMERCETOOLS), new ArrayList<Middleware>(), null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, List<Middleware> middlewares) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, request -> InternalLogger.getLogger(COMMERCETOOLS), middlewares, null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, List<Middleware> middlewares, CorrelationIdProvider correlationIdProvider) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, request -> InternalLogger.getLogger(COMMERCETOOLS), middlewares, correlationIdProvider);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, InternalLoggerFactory internalLoggerFactory, List<Middleware> middlewares) {
        return ClientFactory.create(apiBaseUrl, httpClient, tokenSupplier, internalLoggerFactory, middlewares, null);
    }

    public static ApiHttpClient create(String apiBaseUrl, VrapHttpClient httpClient, TokenSupplier tokenSupplier, InternalLoggerFactory internalLoggerFactory, List<Middleware> middlewares, @Nullable CorrelationIdProvider correlationIdProvider) {
        ArrayList<Middleware> middlewareStack = new ArrayList<Middleware>(MiddlewareFactory.createDefault(tokenSupplier, internalLoggerFactory));
        if (correlationIdProvider != null) {
            middlewares.add((request, next) -> {
                request.withHeader("X-Correlation-ID", correlationIdProvider.getCorrelationId());
                return (CompletableFuture)next.apply(request);
            });
        }
        middlewareStack.addAll(middlewares);
        HandlerStack stack = HandlerStack.create(HttpHandler.create(httpClient), middlewareStack);
        return new ApiHttpClient(apiBaseUrl, stack);
    }
}

