/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.http.ErrorMiddleware;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.InternalLoggerMiddleware;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.OAuthHandler;
import io.vrap.rmf.base.client.http.OAuthMiddleware;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;

public class MiddlewareFactory {
    private static final String userAgent = MiddlewareFactory.buildUserAgent();

    @Deprecated
    public static List<Middleware> createDefault(TokenSupplier tokenSupplier, Logger logger) {
        return MiddlewareFactory.createDefault(tokenSupplier, (ApiHttpRequest request) -> InternalLogger.getLogger("commercetools"));
    }

    public static List<Middleware> createDefault(TokenSupplier tokenSupplier, InternalLoggerFactory internalLoggerFactory) {
        OAuthHandler oAuthHandler = new OAuthHandler(tokenSupplier);
        return Arrays.asList((request, next) -> {
            request.withHeader("User-Agent", userAgent);
            return (CompletableFuture)next.apply(request);
        }, new ErrorMiddleware(), new InternalLoggerMiddleware(internalLoggerFactory), new OAuthMiddleware(oAuthHandler));
    }

    private static String buildUserAgent() {
        String runtimeVersion = SystemUtils.JAVA_RUNTIME_VERSION;
        String osName = SystemUtils.OS_NAME;
        String osArch = SystemUtils.OS_ARCH;
        String sdkVersion = "1.5.1";
        return "commercetools-java-sdks/" + sdkVersion + "  Java/" + runtimeVersion + " (" + osName + "; " + osArch + ")";
    }
}

