/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.utils.json.JsonException;
import io.vrap.rmf.base.client.utils.json.VrapJsonUtils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalLoggerMiddleware
implements Middleware {
    private final Logger classLogger = LoggerFactory.getLogger(InternalLoggerMiddleware.class);
    private final InternalLoggerFactory factory;

    public InternalLoggerMiddleware(InternalLoggerFactory factory) {
        this.factory = factory;
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        InternalLogger logger = this.factory.createFor(request);
        logger.debug(() -> request);
        logger.trace(() -> {
            String output;
            String httpMethodAndUrl = request.getMethod().name() + " " + request.getUrl().toString();
            if (request.getBody() != null) {
                String unformattedBody = request.getSecuredBody();
                boolean isJsonRequest = request.getHeaders().getHeaders("Content-Type").stream().findFirst().map(ct -> ((String)ct.getValue()).toLowerCase().contains("json")).orElse(true);
                if (isJsonRequest) {
                    String prettyPrint;
                    try {
                        prettyPrint = VrapJsonUtils.prettyPrint(unformattedBody);
                    }
                    catch (JsonException e) {
                        this.classLogger.warn("pretty print failed", (Throwable)e);
                        prettyPrint = unformattedBody;
                    }
                    output = "send: " + httpMethodAndUrl + "\nformatted: " + prettyPrint;
                } else {
                    output = "send: " + request.getMethod().name() + " " + request.getUrl() + " " + unformattedBody;
                }
            } else {
                output = httpMethodAndUrl + " <no body>";
            }
            return output;
        });
        return next.apply(request).whenComplete((response, throwable) -> {
            if (throwable != null) {
                if (throwable.getCause() instanceof ApiHttpException) {
                    ApiHttpResponse<byte[]> errorResponse = ((ApiHttpException)throwable.getCause()).getResponse();
                    logger.error(() -> String.format("%s %s %s", request.getMethod().name(), request.getUrl(), errorResponse.getStatusCode()));
                    logger.debug(() -> errorResponse, (Throwable)throwable);
                    logger.trace(() -> errorResponse.getStatusCode() + "\n" + Optional.ofNullable(errorResponse.getBody()).map(body -> VrapJsonUtils.prettyPrint(errorResponse.getBodyAsString().orElse(""))).orElse("<no body>"));
                } else {
                    logger.error(throwable::getCause, (Throwable)throwable);
                }
            } else {
                logger.info(() -> String.format("%s %s %s", request.getMethod().name(), request.getUrl(), response.getStatusCode()));
                logger.debug(() -> response);
                logger.trace(() -> response.getStatusCode() + "\n" + Optional.ofNullable(response.getBody()).map(body -> VrapJsonUtils.prettyPrint(response.getBodyAsString().orElse(""))).orElse("<no body>"));
            }
        });
    }
}

