/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.error.UnauthorizedException;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.OAuthHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthMiddleware
implements Middleware,
AutoCloseable {
    private final OAuthHandler authHandler;
    private final Logger logger = LoggerFactory.getLogger((String)"commercetools.auth");
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);

    public OAuthMiddleware(OAuthHandler oAuthHandler) {
        this(oAuthHandler, 1);
    }

    public OAuthMiddleware(OAuthHandler oauthHandler, Integer maxRetries) {
        RetryPolicy retry = ((RetryPolicy)new RetryPolicy().handleIf((response, throwable) -> {
            if (throwable != null && throwable.getCause() instanceof UnauthorizedException) {
                return true;
            }
            return response.getStatusCode() == 401;
        })).onRetry(event -> {
            this.logger.debug("Refresh Bearer token #" + event.getAttemptCount());
            oauthHandler.refreshToken();
        }).withMaxRetries(maxRetries.intValue());
        this.authHandler = oauthHandler;
        this.failsafeExecutor = Failsafe.with((Policy[])new RetryPolicy[]{retry}).with(this.executor);
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> {
            AuthenticationToken token = this.authHandler.getToken();
            request.addHeader("Authorization", OAuthHandler.authHeader(token));
            return (CompletionStage)next.apply(request);
        });
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.authHandler.close();
    }
}

