/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.Middleware;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryMiddleware
implements Middleware,
AutoCloseable {
    Logger logger = LoggerFactory.getLogger((String)"commercetools");
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;

    public RetryMiddleware(int maxRetries) {
        this(maxRetries, Collections.singletonList(503));
    }

    public RetryMiddleware(int maxRetries, List<Integer> statusCodes) {
        this(maxRetries, 100L, 1000L, statusCodes);
    }

    public RetryMiddleware(int maxRetries, long delay, long maxDelay) {
        this(maxRetries, delay, maxDelay, Collections.singletonList(503));
    }

    public RetryMiddleware(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf((response, throwable) -> {
            if (throwable instanceof ApiHttpException) {
                return statusCodes.contains(((ApiHttpException)throwable).getStatusCode());
            }
            return statusCodes.contains(response.getStatusCode());
        })).withBackoff(delay, maxDelay, ChronoUnit.MILLIS).onRetry(event -> this.logger.info("Retry #" + event.getAttemptCount())).withMaxRetries(maxRetries);
        this.failsafeExecutor = Failsafe.with((Policy[])new RetryPolicy[]{retryPolicy}).with(this.executor);
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> (CompletableFuture)next.apply(request));
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

