/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.oauth2.AuthException;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import io.vrap.rmf.base.client.utils.Utils;
import io.vrap.rmf.base.client.utils.json.VrapJsonUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class ClientCredentialsTokenSupplier
extends AutoCloseableService
implements TokenSupplier {
    private final InternalLogger logger = InternalLogger.getLogger("commercetools.auth");
    private final VrapHttpClient vrapHttpClient;
    private final ApiHttpRequest apiHttpRequest;

    public ClientCredentialsTokenSupplier(String clientId, String clientSecret, String scope, String tokenEndpoint, VrapHttpClient vrapHttpClient) {
        this.vrapHttpClient = vrapHttpClient;
        this.apiHttpRequest = ClientCredentialsTokenSupplier.constructApiHttpRequest(clientId, clientSecret, scope, tokenEndpoint);
    }

    @Override
    public CompletableFuture<AuthenticationToken> getToken() {
        return ((CompletableFuture)((CompletableFuture)this.vrapHttpClient.execute(this.apiHttpRequest).whenComplete((response, throwable) -> {
            if (throwable != null) {
                this.logger.error(() -> response, (Throwable)throwable);
            } else {
                this.logger.debug(() -> response);
            }
        })).thenApply(apiHttpResponse -> {
            if (apiHttpResponse.getStatusCode() < 200 || apiHttpResponse.getStatusCode() > 299) {
                throw new CompletionException(new AuthException(apiHttpResponse.getStatusCode(), new String((byte[])apiHttpResponse.getBody()), this.apiHttpRequest.getHeaders(), apiHttpResponse.getMessage(), (ApiHttpResponse<byte[]>)apiHttpResponse));
            }
            return apiHttpResponse;
        })).thenApply(Utils.wrapToCompletionException(response -> VrapJsonUtils.fromJsonByteArray((byte[])response.getBody(), AuthenticationToken.class)));
    }

    private static ApiHttpRequest constructApiHttpRequest(String clientId, String clientSecret, String scope, String tokenEndpoint) {
        String auth = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        ApiHttpHeaders headers = new ApiHttpHeaders();
        headers.withHeader("Authorization", "Basic " + auth);
        headers.withHeader("Content-Type", "application/x-www-form-urlencoded");
        String body = "";
        if (scope == null || scope.isEmpty()) {
            body = "grant_type=client_credentials";
        } else {
            try {
                body = "grant_type=client_credentials&scope=" + URLEncoder.encode(scope, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(tokenEndpoint), headers, body.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected void internalClose() {
        if (this.vrapHttpClient instanceof AutoCloseable) {
            ClientCredentialsTokenSupplier.closeQuietly((AutoCloseable)((Object)this.vrapHttpClient));
        }
    }
}

