/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import com.spotify.futures.CompletableFutures;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.error.NotFoundException;
import io.vrap.rmf.base.client.http.NotFoundExceptionMiddleware;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;

class NotFoundExceptionMiddlewareImpl
implements NotFoundExceptionMiddleware {
    private final Predicate<ApiHttpRequest> requestPredicate;

    public NotFoundExceptionMiddlewareImpl() {
        this.requestPredicate = apiHttpRequest -> true;
    }

    public NotFoundExceptionMiddlewareImpl(Predicate<ApiHttpRequest> requestPredicate) {
        this.requestPredicate = requestPredicate;
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return CompletableFutures.exceptionallyCompose((CompletionStage)next.apply(request), throwable -> {
            Throwable cause;
            Throwable throwable2 = cause = throwable instanceof CompletionException ? throwable.getCause() : throwable;
            if (cause instanceof NotFoundException && this.requestPredicate.test(request)) {
                ApiHttpResponse<byte[]> response = ((NotFoundException)throwable.getCause()).getResponse();
                return CompletableFuture.completedFuture(new ApiHttpResponse<Object>(response.getStatusCode(), response.getHeaders(), null));
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(throwable.getCause());
            return future;
        }).toCompletableFuture();
    }
}

