/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.Base;
import io.vrap.rmf.base.client.ClientRequestCommand;
import io.vrap.rmf.base.client.CreateHttpRequestCommand;
import io.vrap.rmf.base.client.EncodingException;
import io.vrap.rmf.base.client.RequestCommand;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ApiMethod<T extends ApiMethod<T, TResult>, TResult>
extends Base
implements RequestCommand<TResult>,
ClientRequestCommand<TResult>,
CreateHttpRequestCommand {
    private Function<ApiHttpRequest, ApiHttpRequest> httpRequestDecorator = Function.identity();
    private ApiHttpHeaders headers = new ApiHttpHeaders();
    private List<ParamEntry<String, String>> queryParams = new ArrayList<ParamEntry<String, String>>();
    private final ApiHttpClient apiHttpClient;

    protected ApiHttpClient apiHttpClient() {
        return this.apiHttpClient;
    }

    public ApiMethod(ApiHttpClient apiHttpClient) {
        this.apiHttpClient = apiHttpClient;
    }

    public ApiMethod(ApiHttpClient apiHttpClient, ApiHttpHeaders headers, List<ParamEntry<String, String>> queryParams) {
        this.apiHttpClient = apiHttpClient;
        this.headers = headers;
        this.queryParams = new ArrayList<ParamEntry<String, String>>(queryParams);
    }

    public ApiMethod(ApiMethod<T, TResult> apiMethod) {
        this.apiHttpClient = apiMethod.apiHttpClient;
        this.headers = new ApiHttpHeaders(apiMethod.headers);
        this.queryParams = new ArrayList<ParamEntry<String, String>>(apiMethod.queryParams);
        this.httpRequestDecorator = apiMethod.httpRequestDecorator;
    }

    public T addHeader(String key, String value) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.addHeader(key, value);
        return c;
    }

    public T withoutHeader(String key) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withoutHeader(key);
        return c;
    }

    public T withHeader(String key, String value) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withHeader(key, value);
        return c;
    }

    public T withHeaders(ApiHttpHeaders headers) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers = headers;
        return c;
    }

    public T contentType(String contentType) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withHeader("Content-Type", contentType);
        return c;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    public <V> T addQueryParam(String key, V value) {
        T c = this.copy();
        ((ApiMethod)c).queryParams.add(new ParamEntry<String, String>(key, value.toString()));
        return c;
    }

    public <V> T withQueryParam(String key, V value) {
        return ((ApiMethod)this.withoutQueryParam(key)).addQueryParam(key, value);
    }

    public T withoutQueryParam(String key) {
        T c = this.copy();
        ((ApiMethod)c).queryParams = ((ApiMethod)c).queryParams.stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase(key)).collect(Collectors.toList());
        return c;
    }

    public T withQueryParams(List<ParamEntry<String, String>> queryParams) {
        T c = this.copy();
        ((ApiMethod)c).queryParams = queryParams;
        return c;
    }

    public T addQueryParams(List<ParamEntry<String, String>> queryParams) {
        T c = this.copy();
        ((ApiMethod)c).queryParams.addAll(queryParams);
        return c;
    }

    public List<ParamEntry<String, String>> getQueryParams() {
        return new ArrayList<ParamEntry<String, String>>(this.queryParams);
    }

    public List<String> getQueryParam(String key) {
        return this.queryParams.stream().filter(e -> ((String)e.key).equals(key)).map(e -> (String)e.value).collect(Collectors.toList());
    }

    public List<String> getQueryParamUriStrings() {
        return this.queryParams.stream().map(ParamEntry::toUriString).collect(Collectors.toList());
    }

    public String getQueryParamUriString() {
        return this.queryParams.stream().map(ParamEntry::toUriString).collect(Collectors.joining("&"));
    }

    @Nullable
    public String getFirstQueryParam(String key) {
        return this.queryParams.stream().filter(e -> ((String)e.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    protected abstract T copy();

    protected abstract ApiHttpRequest buildHttpRequest();

    @Override
    public ApiHttpRequest createHttpRequest() {
        return this.httpRequestDecorator.apply(this.buildHttpRequest());
    }

    @Override
    public CompletableFuture<ApiHttpResponse<TResult>> execute() {
        return this.execute(this.apiHttpClient());
    }

    @Override
    public abstract CompletableFuture<ApiHttpResponse<TResult>> execute(ApiHttpClient var1);

    public T withHttpRequest(Function<ApiHttpRequest, ApiHttpRequest> op) {
        T c = this.copy();
        ((ApiMethod)c).httpRequestDecorator = this.httpRequestDecorator.andThen(op);
        return c;
    }

    public T with(Function<T, T> op) {
        T c = this.copy();
        return (T)((ApiMethod)op.apply(c));
    }

    public <U> T with(BiFunction<T, U, T> op, U arg) {
        T c = this.copy();
        return (T)((ApiMethod)op.apply(c, arg));
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(Class<TReturn> returnType) {
        return this.execute(this.apiHttpClient(), returnType);
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(ApiHttpClient client, Class<TReturn> returnType) {
        return ((CompletableFuture)client.execute((CreateHttpRequestCommand)this, (Class)returnType)).toCompletableFuture();
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(TypeReference<TReturn> returnTypeReference) {
        return this.execute(this.apiHttpClient(), returnTypeReference);
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(ApiHttpClient client, TypeReference<TReturn> returnTypeReference) {
        return ((CompletableFuture)client.execute((CreateHttpRequestCommand)this, (TypeReference)returnTypeReference)).toCompletableFuture();
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(JavaType returnJavaType) {
        return this.execute(this.apiHttpClient(), returnJavaType);
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(ApiHttpClient client, JavaType returnJavaType) {
        return client.execute((CreateHttpRequestCommand)this, returnJavaType);
    }

    @Override
    public ApiHttpResponse<TResult> executeBlocking(Duration timeout) {
        return this.executeBlocking(this.apiHttpClient(), timeout);
    }

    @Override
    public abstract ApiHttpResponse<TResult> executeBlocking(ApiHttpClient var1, Duration var2);

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Class<TReturn> clazz) {
        return this.executeBlocking(this.apiHttpClient(), ApiHttpClient.DEFAULT_TIMEOUT, clazz);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Class<TReturn> clazz) {
        return this.executeBlocking(client, ApiHttpClient.DEFAULT_TIMEOUT, clazz);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Duration timeout, Class<TReturn> clazz) {
        return this.executeBlocking(this.apiHttpClient(), timeout, clazz);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Duration timeout, Class<TReturn> clazz) {
        return client.executeBlocking((CreateHttpRequestCommand)this, clazz, timeout);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(TypeReference<TReturn> typeReference) {
        return this.executeBlocking(this.apiHttpClient(), ApiHttpClient.DEFAULT_TIMEOUT, typeReference);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, TypeReference<TReturn> typeReference) {
        return this.executeBlocking(client, ApiHttpClient.DEFAULT_TIMEOUT, typeReference);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Duration timeout, TypeReference<TReturn> typeReference) {
        return this.executeBlocking(this.apiHttpClient(), timeout, typeReference);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Duration timeout, TypeReference<TReturn> typeReference) {
        return client.executeBlocking((CreateHttpRequestCommand)this, typeReference, timeout);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(JavaType javaType) {
        return this.executeBlocking(this.apiHttpClient(), ApiHttpClient.DEFAULT_TIMEOUT, javaType);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, JavaType javaType) {
        return this.executeBlocking(this.apiHttpClient(), ApiHttpClient.DEFAULT_TIMEOUT, javaType);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Duration timeout, JavaType javaType) {
        return this.executeBlocking(this.apiHttpClient(), timeout, javaType);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Duration timeout, JavaType javaType) {
        return client.executeBlocking((CreateHttpRequestCommand)this, javaType, timeout);
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> send() {
        return this.apiHttpClient.send(this);
    }

    public ApiHttpResponse<byte[]> sendBlocking() {
        return this.sendBlocking(ApiHttpClient.DEFAULT_TIMEOUT);
    }

    public ApiHttpResponse<byte[]> sendBlocking(Duration timeout) {
        return this.apiHttpClient.sendBlocking(this, timeout);
    }

    public static class ParamEntry<K, V>
    extends Base
    implements Map.Entry<K, V> {
        protected final K key;
        protected V value;

        public ParamEntry(K key) {
            this.key = key;
        }

        public ParamEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toUriString() {
            try {
                return this.key + "=" + URLEncoder.encode(this.value.toString(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new EncodingException(e);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamEntry that = (ParamEntry)o;
            return new EqualsBuilder().append(this.key, that.key).append(this.value, that.value).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.key).append(this.value).toHashCode();
        }
    }
}

