/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.error.HttpExceptionFactory;
import io.vrap.rmf.base.client.http.ErrorMiddlewareImpl;
import io.vrap.rmf.base.client.http.Middleware;
import java.util.Arrays;
import java.util.Optional;

public interface ErrorMiddleware
extends Middleware {
    public static ErrorMiddleware of() {
        return ErrorMiddleware.of(HttpExceptionFactory.of(ResponseSerializer.of()), ExceptionMode.COMPLETION_EXCEPTION);
    }

    @Deprecated
    public static ErrorMiddleware of(ResponseSerializer serializer) {
        return ErrorMiddleware.of(HttpExceptionFactory.of(serializer), ExceptionMode.COMPLETION_EXCEPTION);
    }

    public static ErrorMiddleware of(HttpExceptionFactory exceptionFactory) {
        return ErrorMiddleware.of(exceptionFactory, ExceptionMode.COMPLETION_EXCEPTION);
    }

    public static ErrorMiddleware of(ExceptionMode exceptionMode) {
        return ErrorMiddleware.of(HttpExceptionFactory.of(ResponseSerializer.of()), exceptionMode);
    }

    public static ErrorMiddleware of(HttpExceptionFactory exceptionFactory, ExceptionMode exceptionMode) {
        return new ErrorMiddlewareImpl(exceptionFactory, exceptionMode);
    }

    public static enum ExceptionMode {
        COMPLETION_EXCEPTION("completion_exception"),
        UNWRAP_COMPLETION_EXCEPTION("unwrap");

        private final String mode;

        private ExceptionMode(String mode) {
            this.mode = mode;
        }

        public String getMode() {
            return this.mode;
        }

        public static Optional<ExceptionMode> get(String mode) {
            return Arrays.stream(ExceptionMode.values()).filter(env -> env.mode.equals(mode)).findFirst();
        }
    }
}

