/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.HttpClientSupplier;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.ServiceRegionConfig;
import io.vrap.rmf.base.client.UserAgentUtils;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.error.HttpExceptionFactory;
import io.vrap.rmf.base.client.http.AcceptGZipMiddleware;
import io.vrap.rmf.base.client.http.CorrelationIdProvider;
import io.vrap.rmf.base.client.http.ErrorMiddleware;
import io.vrap.rmf.base.client.http.FailsafeRetryPolicyBuilderOptions;
import io.vrap.rmf.base.client.http.HandlerStack;
import io.vrap.rmf.base.client.http.HttpHandler;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.InternalLoggerMiddleware;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.NotFoundExceptionMiddleware;
import io.vrap.rmf.base.client.http.OAuthHandler;
import io.vrap.rmf.base.client.http.OAuthMiddleware;
import io.vrap.rmf.base.client.http.QueueRequestMiddleware;
import io.vrap.rmf.base.client.http.RetryRequestMiddleware;
import io.vrap.rmf.base.client.http.TelemetryMiddleware;
import io.vrap.rmf.base.client.http.UserAgentMiddleware;
import io.vrap.rmf.base.client.oauth2.AnonymousFlowTokenSupplier;
import io.vrap.rmf.base.client.oauth2.AnonymousSessionTokenSupplier;
import io.vrap.rmf.base.client.oauth2.ClientCredentials;
import io.vrap.rmf.base.client.oauth2.ClientCredentialsTokenSupplier;
import io.vrap.rmf.base.client.oauth2.GlobalCustomerPasswordTokenSupplier;
import io.vrap.rmf.base.client.oauth2.InMemoryTokenSupplier;
import io.vrap.rmf.base.client.oauth2.RefreshFlowTokenSupplier;
import io.vrap.rmf.base.client.oauth2.StaticTokenSupplier;
import io.vrap.rmf.base.client.oauth2.TokenStorage;
import io.vrap.rmf.base.client.oauth2.TokenStorageSupplier;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.event.Level;

public class ClientBuilder
implements Builder<ApiHttpClient> {
    public static final String COMMERCETOOLS = "commercetools";
    static final String userAgent = "commercetools-sdk-java-v2/";
    private URI apiBaseUrl;
    private boolean useAuthCircuitBreaker;
    private int authRetries;
    private Supplier<ErrorMiddleware> errorMiddleware;
    private Supplier<OAuthMiddleware> oAuthMiddleware;
    private Supplier<RetryRequestMiddleware> retryMiddleware;
    private Supplier<QueueRequestMiddleware> queueMiddleware;
    private Supplier<Middleware> correlationIdMiddleware;
    private InternalLoggerMiddleware internalLoggerMiddleware;
    private UserAgentMiddleware userAgentMiddleware;
    private Supplier<TelemetryMiddleware> telemetryMiddleware;
    private List<Middleware> middlewares = new ArrayList<Middleware>();
    private Supplier<HandlerStack> stack;
    private VrapHttpClient httpClient;
    private VrapHttpClient oauthHttpClient;
    private Supplier<ResponseSerializer> serializer;
    private Supplier<HttpExceptionFactory> httpExceptionFactory;
    private Supplier<ExecutorService> oauthExecutorService = ForkJoinPool::new;

    public static ClientBuilder of() {
        return new ClientBuilder();
    }

    public static ClientBuilder of(ExecutorService httpClientExecutorService) {
        return new ClientBuilder(httpClientExecutorService);
    }

    public static ClientBuilder of(VrapHttpClient httpClient) {
        return new ClientBuilder(httpClient);
    }

    public static ClientBuilder of(ApiHttpClient httpClient) {
        return new ClientBuilder(httpClient);
    }

    public static ClientBuilder of(HandlerStack stack) {
        return new ClientBuilder(stack);
    }

    private ClientBuilder(HandlerStack stack) {
        this.stack = () -> stack;
        this.serializer = ResponseSerializer::of;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.useAuthCircuitBreaker = false;
        this.authRetries = 1;
    }

    private ClientBuilder() {
        this.oauthHttpClient = this.httpClient = HttpClientSupplier.of(new ForkJoinPool()).get();
        this.stack = this.stackSupplier();
        this.serializer = ResponseSerializer::of;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.useAuthCircuitBreaker = false;
        this.authRetries = 1;
    }

    private ClientBuilder(ExecutorService httpClientExecutorService) {
        this.oauthHttpClient = this.httpClient = HttpClientSupplier.of(httpClientExecutorService).get();
        this.stack = this.stackSupplier();
        this.serializer = ResponseSerializer::of;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.useAuthCircuitBreaker = false;
        this.authRetries = 1;
    }

    private ClientBuilder(ApiHttpClient httpClient) {
        this.httpClient = httpClient;
        this.oauthHttpClient = HttpClientSupplier.of(new ForkJoinPool()).get();
        this.stack = this.stackSupplier();
        this.serializer = ResponseSerializer::of;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.authRetries = 1;
    }

    private ClientBuilder(VrapHttpClient httpClient) {
        this.httpClient = httpClient;
        this.oauthHttpClient = httpClient;
        this.stack = this.stackSupplier();
        this.serializer = ResponseSerializer::of;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.authRetries = 1;
    }

    private Supplier<HandlerStack> stackSupplier() {
        return () -> {
            ArrayList<Middleware> middlewareStack = new ArrayList<Middleware>();
            Optional.ofNullable(this.telemetryMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.errorMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.internalLoggerMiddleware).map(middlewareStack::add);
            Optional.ofNullable(this.userAgentMiddleware).map(middlewareStack::add);
            Optional.ofNullable(this.oAuthMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.retryMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.queueMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.correlationIdMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            middlewareStack.addAll(this.middlewares);
            return HandlerStack.create(HttpHandler.create(Objects.requireNonNull(this.httpClient)), middlewareStack);
        };
    }

    private Supplier<HandlerStack> oauthHandlerSupplier() {
        return () -> {
            ArrayList<Middleware> middlewareStack = new ArrayList<Middleware>();
            Optional.ofNullable(this.userAgentMiddleware).map(middlewareStack::add);
            Optional.ofNullable(this.correlationIdMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            return HandlerStack.create(HttpHandler.create(Objects.requireNonNull(this.oauthHttpClient)), middlewareStack);
        };
    }

    public ClientBuilder withoutAuthCircuitBreaker() {
        this.useAuthCircuitBreaker = false;
        return this;
    }

    public ClientBuilder withAuthCircuitBreaker() {
        this.useAuthCircuitBreaker = true;
        return this;
    }

    public ClientBuilder withAuthRetries(int authRetries) {
        this.authRetries = authRetries;
        return this;
    }

    public ClientBuilder withHandlerStack(HandlerStack stack) {
        this.stack = () -> stack;
        return this;
    }

    public ClientBuilder withHttpClient(VrapHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ClientBuilder withOAuthHttpClient(VrapHttpClient httpClient) {
        this.oauthHttpClient = httpClient;
        return this;
    }

    public ClientBuilder withSerializer(ResponseSerializer serializer) {
        this.serializer = () -> serializer;
        return this;
    }

    public ClientBuilder withSerializer(Supplier<ResponseSerializer> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ClientBuilder withHttpExceptionFactory(HttpExceptionFactory factory) {
        this.httpExceptionFactory = () -> factory;
        return this;
    }

    public ClientBuilder withHttpExceptionFactory(Function<ResponseSerializer, HttpExceptionFactory> factory) {
        this.httpExceptionFactory = () -> (HttpExceptionFactory)factory.apply(this.serializer.get());
        return this;
    }

    public ClientBuilder withHttpExceptionFactory(Supplier<HttpExceptionFactory> factory) {
        this.httpExceptionFactory = factory;
        return this;
    }

    public ClientBuilder withOAuthExecutorService(Supplier<ExecutorService> executorService) {
        this.oauthExecutorService = executorService;
        return this;
    }

    public ClientBuilder withOAuthExecutorService(ExecutorService executorService) {
        this.oauthExecutorService = () -> executorService;
        return this;
    }

    public ClientBuilder defaultClient(URI apiBaseUrl) {
        return this.withApiBaseUrl(apiBaseUrl).withErrorMiddleware().withSerializer(ResponseSerializer::of).withInternalLoggerFactory((request, topic) -> InternalLogger.getLogger("commercetools." + topic)).withUserAgentSupplier(ClientBuilder::buildDefaultUserAgent).addAcceptGZipMiddleware();
    }

    public ClientBuilder defaultClient(String apiBaseUrl) {
        return this.defaultClient(URI.create(apiBaseUrl));
    }

    public ClientBuilder defaultClient(String apiBaseUrl, ClientCredentials credentials, String tokenEndpoint) {
        return this.defaultClient(apiBaseUrl).withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    public ClientBuilder defaultClient(ClientCredentials credentials, ServiceRegionConfig serviceRegionConfig) {
        return this.defaultClient(serviceRegionConfig.getApiUrl()).withClientCredentialsFlow(credentials, serviceRegionConfig.getOAuthTokenUrl());
    }

    @Deprecated
    public ClientBuilder withClientCredentials(ClientCredentials credentials, String tokenEndpoint) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    @Deprecated
    public ClientBuilder withClientCredentials(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint, httpClient);
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint.toString());
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint.toString(), httpClientSupplier);
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint, VrapHttpClient httpClient) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint.toString(), httpClient);
    }

    private TokenSupplier createClientCredentialsTokenSupplier(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return new ClientCredentialsTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), credentials.getScopes(), tokenEndpoint, httpClient, serializer);
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint, this.oauthHandlerSupplier());
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createClientCredentialsTokenSupplier(credentials, tokenEndpoint, (VrapHttpClient)httpClientSupplier.get(), this.serializer.get())));
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createClientCredentialsTokenSupplier(credentials, tokenEndpoint, httpClient, this.serializer.get())));
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createClientCredentialsTokenSupplier(credentials, tokenEndpoint, httpClient, serializer)));
    }

    public ClientBuilder withStaticTokenFlow(AuthenticationToken token) {
        return this.withTokenSupplier(new StaticTokenSupplier(token));
    }

    public ClientBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint) {
        return this.withAnonymousSessionFlow(credentials, tokenEndpoint, this.oauthHandlerSupplier());
    }

    public ClientBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createAnonymousSessionTokenSupplier(credentials, tokenEndpoint, (VrapHttpClient)httpClientSupplier.get(), this.serializer.get())));
    }

    public ClientBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createAnonymousSessionTokenSupplier(credentials, tokenEndpoint, httpClient, this.serializer.get())));
    }

    public ClientBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createAnonymousSessionTokenSupplier(credentials, tokenEndpoint, httpClient, serializer)));
    }

    private TokenSupplier createAnonymousSessionTokenSupplier(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return new AnonymousSessionTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), credentials.getScopes(), tokenEndpoint, httpClient, serializer);
    }

    public ClientBuilder withAnonymousRefreshFlow(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage storage) {
        return this.withAnonymousRefreshFlow(credentials, anonTokenEndpoint, refreshTokenEndpoint, storage, this.oauthHandlerSupplier());
    }

    public ClientBuilder withAnonymousRefreshFlow(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage storage, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createAnonymousRefreshFlowSupplier(credentials, anonTokenEndpoint, refreshTokenEndpoint, storage, (VrapHttpClient)httpClientSupplier.get(), this.serializer.get()));
    }

    public ClientBuilder withAnonymousRefreshFlow(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage storage, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createAnonymousRefreshFlowSupplier(credentials, anonTokenEndpoint, refreshTokenEndpoint, storage, httpClient, this.serializer.get()));
    }

    public ClientBuilder withAnonymousRefreshFlow(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage storage, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return this.withTokenSupplier(() -> this.createAnonymousRefreshFlowSupplier(credentials, anonTokenEndpoint, refreshTokenEndpoint, storage, httpClient, serializer));
    }

    private TokenSupplier createInMemoryTokenSupplier(TokenSupplier tokenSupplier) {
        return Optional.ofNullable(this.oauthExecutorService).map(executorService -> new InMemoryTokenSupplier((ExecutorService)executorService.get(), tokenSupplier)).orElse(new InMemoryTokenSupplier(tokenSupplier));
    }

    private TokenSupplier createAnonymousRefreshFlowSupplier(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage tokenStorage, VrapHttpClient httpClient, ResponseSerializer serializer) {
        RefreshFlowTokenSupplier refreshFlowTokenSupplier = this.createRefreshFlowSupplier(credentials, refreshTokenEndpoint, tokenStorage, httpClient, serializer);
        AnonymousFlowTokenSupplier anonymousFlowTokenSupplier = new AnonymousFlowTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), credentials.getScopes(), anonTokenEndpoint, refreshFlowTokenSupplier, httpClient, serializer);
        return new TokenStorageSupplier(tokenStorage, anonymousFlowTokenSupplier);
    }

    private RefreshFlowTokenSupplier createRefreshFlowSupplier(ClientCredentials credentials, String tokenEndpoint, TokenStorage tokenStorage, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return new RefreshFlowTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), tokenEndpoint, tokenStorage, httpClient, serializer);
    }

    public ClientBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint) {
        return this.withGlobalCustomerPasswordFlow(credentials, email, password, tokenEndpoint, this.oauthHandlerSupplier());
    }

    public ClientBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createGlobalCustomerPasswordTokenSupplier(credentials, email, password, tokenEndpoint, (VrapHttpClient)httpClientSupplier.get(), this.serializer.get())));
    }

    public ClientBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createGlobalCustomerPasswordTokenSupplier(credentials, email, password, tokenEndpoint, httpClient, this.serializer.get())));
    }

    public ClientBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createGlobalCustomerPasswordTokenSupplier(credentials, email, password, tokenEndpoint, httpClient, serializer)));
    }

    private TokenSupplier createGlobalCustomerPasswordTokenSupplier(ClientCredentials credentials, String email, String password, String tokenEndpoint, VrapHttpClient httpClient, ResponseSerializer serializer) {
        return new GlobalCustomerPasswordTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), email, password, credentials.getScopes(), tokenEndpoint, httpClient, serializer);
    }

    public ClientBuilder addAcceptGZipMiddleware() {
        return this.addMiddleware(AcceptGZipMiddleware.of(), new Middleware[0]);
    }

    public ClientBuilder withErrorMiddleware(Supplier<ErrorMiddleware> errorMiddleware) {
        this.errorMiddleware = errorMiddleware;
        return this;
    }

    public ClientBuilder withErrorMiddleware() {
        return this.withErrorMiddleware(() -> ErrorMiddleware.of(this.httpExceptionFactory.get()));
    }

    public ClientBuilder withErrorMiddleware(ErrorMiddleware errorMiddleware) {
        return this.withErrorMiddleware(() -> errorMiddleware);
    }

    public ClientBuilder withErrorMiddleware(ErrorMiddleware.ExceptionMode exceptionMode) {
        return this.withErrorMiddleware(() -> ErrorMiddleware.of(this.httpExceptionFactory.get(), exceptionMode));
    }

    public ClientBuilder withTelemetryMiddleware(Supplier<TelemetryMiddleware> telemetryMiddleware) {
        this.telemetryMiddleware = telemetryMiddleware;
        return this;
    }

    public ClientBuilder withTelemetryMiddleware(TelemetryMiddleware telemetryMiddleware) {
        return this.withTelemetryMiddleware(() -> telemetryMiddleware);
    }

    public ClientBuilder addNotFoundExceptionMiddleware() {
        return this.addNotFoundExceptionMiddleware(NotFoundExceptionMiddleware.of());
    }

    public ClientBuilder addNotFoundExceptionMiddleware(Set<ApiHttpMethod> methods) {
        return this.addNotFoundExceptionMiddleware(NotFoundExceptionMiddleware.of(methods));
    }

    public ClientBuilder addNotFoundExceptionMiddleware(Predicate<ApiHttpRequest> requestPredicate) {
        return this.addNotFoundExceptionMiddleware(NotFoundExceptionMiddleware.of(requestPredicate));
    }

    public ClientBuilder addNotFoundExceptionMiddleware(NotFoundExceptionMiddleware exceptionMiddleware) {
        return this.addMiddleware(exceptionMiddleware, new Middleware[0]);
    }

    public ClientBuilder withRetryMiddleware(Supplier<RetryRequestMiddleware> retryMiddleware) {
        this.retryMiddleware = retryMiddleware;
        return this;
    }

    public ClientBuilder withRetryMiddleware(RetryRequestMiddleware retryMiddleware) {
        return this.withRetryMiddleware(() -> retryMiddleware);
    }

    public ClientBuilder withRetryMiddleware(int maxRetries) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(maxRetries));
    }

    public ClientBuilder withRetryMiddleware(int maxRetries, List<Integer> statusCodes) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(maxRetries, statusCodes));
    }

    public ClientBuilder withRetryMiddleware(int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(maxRetries, statusCodes, failures));
    }

    public ClientBuilder withRetryMiddleware(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes).andThen(fn))));
    }

    public ClientBuilder withRetryMiddleware(int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(maxRetries, delay, maxDelay, fn));
    }

    public ClientBuilder withRetryMiddleware(ExecutorService executorService, int maxRetries) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries));
    }

    public ClientBuilder withRetryMiddleware(ExecutorService executorService, int maxRetries, List<Integer> statusCodes) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, statusCodes));
    }

    public ClientBuilder withRetryMiddleware(ExecutorService executorService, int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, statusCodes, failures));
    }

    public ClientBuilder withRetryMiddleware(ExecutorService executorService, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes).andThen(fn))));
    }

    public ClientBuilder withRetryMiddleware(ExecutorService executorService, int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, delay, maxDelay, fn));
    }

    public ClientBuilder withRetryMiddleware(ScheduledExecutorService executorService, int maxRetries) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries));
    }

    public ClientBuilder withRetryMiddleware(ScheduledExecutorService executorService, int maxRetries, List<Integer> statusCodes) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, statusCodes));
    }

    public ClientBuilder withRetryMiddleware(ScheduledExecutorService executorService, int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, statusCodes, failures));
    }

    public ClientBuilder withRetryMiddleware(ScheduledExecutorService executorService, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes).andThen(fn))));
    }

    public ClientBuilder withRetryMiddleware(ScheduledExecutorService executorService, int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(executorService, maxRetries, delay, maxDelay, fn));
    }

    public ClientBuilder withRetryMiddleware(Scheduler scheduler, int maxRetries) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(scheduler, maxRetries));
    }

    public ClientBuilder withRetryMiddleware(Scheduler scheduler, int maxRetries, List<Integer> statusCodes) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(scheduler, maxRetries, statusCodes));
    }

    public ClientBuilder withRetryMiddleware(Scheduler scheduler, int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(scheduler, maxRetries, statusCodes, failures));
    }

    public ClientBuilder withRetryMiddleware(Scheduler scheduler, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(scheduler, maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes).andThen(fn))));
    }

    public ClientBuilder withRetryMiddleware(Scheduler scheduler, int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        return this.withRetryMiddleware(RetryRequestMiddleware.of(scheduler, maxRetries, delay, maxDelay, fn));
    }

    public ClientBuilder withQueueMiddleware(Supplier<QueueRequestMiddleware> queueMiddleware) {
        this.queueMiddleware = queueMiddleware;
        return this;
    }

    public ClientBuilder withQueueMiddleware(QueueRequestMiddleware queueMiddleware) {
        return this.withQueueMiddleware(() -> queueMiddleware);
    }

    public ClientBuilder withQueueMiddleware(int maxRequests, Duration maxWaitTime) {
        return this.withQueueMiddleware(() -> QueueRequestMiddleware.of(maxRequests, maxWaitTime));
    }

    public ClientBuilder withQueueMiddleware(Scheduler scheduler, int maxRequests, Duration maxWaitTime) {
        return this.withQueueMiddleware(() -> QueueRequestMiddleware.of(scheduler, maxRequests, maxWaitTime));
    }

    public ClientBuilder withQueueMiddleware(ScheduledExecutorService executorService, int maxRequests, Duration maxWaitTime) {
        return this.withQueueMiddleware(() -> QueueRequestMiddleware.of(executorService, maxRequests, maxWaitTime));
    }

    public ClientBuilder withQueueMiddleware(ExecutorService executorService, int maxRequests, Duration maxWaitTime) {
        return this.withQueueMiddleware(() -> QueueRequestMiddleware.of(executorService, maxRequests, maxWaitTime));
    }

    public ClientBuilder withOAuthMiddleware(Supplier<OAuthMiddleware> oAuthMiddleware) {
        this.oAuthMiddleware = oAuthMiddleware;
        return this;
    }

    public ClientBuilder withOAuthMiddleware(OAuthMiddleware oAuthMiddleware) {
        return this.withOAuthMiddleware(() -> oAuthMiddleware);
    }

    public ClientBuilder withTokenSupplier(Supplier<TokenSupplier> tokenSupplier) {
        return this.withOAuthMiddleware(() -> {
            OAuthHandler oAuthHandler = new OAuthHandler((TokenSupplier)tokenSupplier.get());
            return Optional.ofNullable(this.oauthExecutorService).map(executorService -> OAuthMiddleware.of((ExecutorService)executorService.get(), oAuthHandler, this.authRetries, this.useAuthCircuitBreaker)).orElseGet(() -> OAuthMiddleware.of(oAuthHandler, this.authRetries, this.useAuthCircuitBreaker));
        });
    }

    public ClientBuilder withTokenSupplier(TokenSupplier tokenSupplier) {
        return this.withTokenSupplier(() -> tokenSupplier);
    }

    public ClientBuilder withInternalLoggerMiddleware(InternalLoggerMiddleware internalLoggerMiddleware) {
        this.internalLoggerMiddleware = internalLoggerMiddleware;
        return this;
    }

    public ClientBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory) {
        return this.withInternalLoggerMiddleware(InternalLoggerMiddleware.of(internalLoggerFactory));
    }

    public ClientBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent) {
        return this.withInternalLoggerMiddleware(InternalLoggerMiddleware.of(internalLoggerFactory, responseLogEvent, deprecationLogEvent));
    }

    public ClientBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent, Level defaultExceptionLogEvent, Map<Class<? extends Throwable>, Level> exceptionLogEvents) {
        return this.withInternalLoggerMiddleware(InternalLoggerMiddleware.of(internalLoggerFactory, responseLogEvent, deprecationLogEvent, defaultExceptionLogEvent, exceptionLogEvents));
    }

    public ClientBuilder withApiBaseUrl(String apiBaseUrl) {
        return this.withApiBaseUrl(URI.create(apiBaseUrl));
    }

    public ClientBuilder withApiBaseUrl(URI apiBaseUrl) {
        if (!apiBaseUrl.getPath().endsWith("/")) {
            this.apiBaseUrl = URI.create(apiBaseUrl + "/");
            return this;
        }
        this.apiBaseUrl = apiBaseUrl;
        return this;
    }

    public ClientBuilder withUserAgentSupplier(Supplier<String> userAgentSupplier) {
        return this.withUserAgentMiddleware(new UserAgentMiddleware(userAgentSupplier.get()));
    }

    private ClientBuilder withUserAgentMiddleware(UserAgentMiddleware userAgentMiddleware) {
        this.userAgentMiddleware = userAgentMiddleware;
        return this;
    }

    public ClientBuilder addCorrelationIdProvider(@Nullable CorrelationIdProvider correlationIdProvider, boolean replace) {
        if (!replace && this.correlationIdMiddleware != null) {
            return this;
        }
        if (correlationIdProvider != null) {
            this.correlationIdMiddleware = () -> (request, next) -> {
                if (request.getHeaders().getFirst("X-Correlation-ID") != null) {
                    return (CompletableFuture)next.apply(request);
                }
                return (CompletableFuture)next.apply(request.withHeader("X-Correlation-ID", correlationIdProvider.getCorrelationId()));
            };
        }
        return this;
    }

    public ClientBuilder addCorrelationIdProvider(@Nullable CorrelationIdProvider correlationIdProvider) {
        return this.addCorrelationIdProvider(correlationIdProvider, true);
    }

    public ClientBuilder withMiddlewares(List<Middleware> middlewares) {
        this.middlewares = new ArrayList<Middleware>(middlewares);
        return this;
    }

    public ClientBuilder withMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.middlewares = new ArrayList<Middleware>(Collections.singletonList(middleware));
        if (middlewares.length > 0) {
            this.middlewares.addAll(Arrays.asList(middlewares));
        }
        return this;
    }

    public ClientBuilder addMiddlewares(List<Middleware> middlewares) {
        this.middlewares.addAll(middlewares);
        return this;
    }

    public ClientBuilder addMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.middlewares.add(middleware);
        if (middlewares.length > 0) {
            this.middlewares.addAll(Arrays.asList(middlewares));
        }
        return this;
    }

    @Override
    public ApiHttpClient build() {
        return ApiHttpClient.of(Objects.requireNonNull(this.apiBaseUrl), Objects.requireNonNull(this.stack.get()), Objects.requireNonNull(this.serializer.get()));
    }

    public static String buildDefaultUserAgent() {
        return UserAgentUtils.obtainUserAgent();
    }
}

