/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.SolutionInfo;
import io.vrap.rmf.base.client.SolutionInfoService;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.LoggerFactory;

final class UserAgentUtils {
    static final String unknownUserAgent = "commercetools-java-v2/unknown";
    static final String userAgent = "commercetools-sdk-java-v2";

    private UserAgentUtils() {
    }

    static String obtainUserAgent() {
        try {
            return UserAgentUtils.userAgent(Collections.emptyList());
        }
        catch (Exception e) {
            LoggerFactory.getLogger(UserAgentUtils.class).error("cannot determine user agent", (Throwable)e);
            return unknownUserAgent;
        }
    }

    static String obtainUserAgent(List<SolutionInfo> additionalSolutionInfos) {
        try {
            return UserAgentUtils.userAgent(additionalSolutionInfos);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(UserAgentUtils.class).error("cannot determine user agent", (Throwable)e);
            return unknownUserAgent;
        }
    }

    private static String userAgent(List<SolutionInfo> additionalSolutionInfos) {
        return MessageFormat.format("{0}/{1} Java/{2} ({3}; {4}) {5}", userAgent, "16.5.0", SystemUtils.JAVA_RUNTIME_VERSION, SystemUtils.OS_NAME, SystemUtils.OS_ARCH, UserAgentUtils.getSolutionInfoString(additionalSolutionInfos)).trim();
    }

    private static String getSolutionInfoString(List<SolutionInfo> additionalSolutionInfos) {
        return Stream.of(SolutionInfoService.getInstance().getSolutionInfos(), additionalSolutionInfos).flatMap(Collection::stream).map(UserAgentUtils::format).collect(Collectors.joining(" "));
    }

    public static String format(SolutionInfo solutionInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(solutionInfo.getName()).append("/").append(solutionInfo.getVersion());
        if (StringUtils.isNotEmpty((CharSequence)solutionInfo.getWebsite()) && StringUtils.isNotEmpty((CharSequence)solutionInfo.getEmergencyContact())) {
            stringBuilder.append(" (");
            String details = Stream.of(solutionInfo.getWebsite(), solutionInfo.getEmergencyContact()).filter(Objects::nonNull).map(s -> "+" + s).collect(Collectors.joining("; "));
            stringBuilder.append(details);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

