/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class InternalLogger {
    private final Logger underlyingLogger;
    public static final String TOPIC_REQUEST = "request";
    public static final String TOPIC_RESPONSE = "response";

    protected InternalLogger(Logger underlyingLogger) {
        this.underlyingLogger = underlyingLogger;
    }

    public static InternalLogger getLogger(Class<?> clazz) {
        return new InternalLogger(LoggerFactory.getLogger(clazz));
    }

    public static InternalLogger getLogger(String loggerName) {
        return new InternalLogger(LoggerFactory.getLogger((String)loggerName));
    }

    public boolean isTraceEnabled() {
        return this.underlyingLogger.isTraceEnabled();
    }

    public InternalLogger debug(Supplier<Object> message) {
        if (this.underlyingLogger.isDebugEnabled()) {
            this.underlyingLogger.debug(message.get().toString());
        }
        return this;
    }

    public InternalLogger debug(Supplier<Object> message, Throwable throwable) {
        if (this.underlyingLogger.isDebugEnabled()) {
            this.underlyingLogger.debug(message.get().toString(), throwable);
        }
        return this;
    }

    public InternalLogger info(Supplier<Object> message) {
        if (this.underlyingLogger.isInfoEnabled()) {
            this.underlyingLogger.info(message.get().toString());
        }
        return this;
    }

    public InternalLogger info(Supplier<Object> message, Throwable throwable) {
        if (this.underlyingLogger.isInfoEnabled()) {
            this.underlyingLogger.info(message.get().toString(), throwable);
        }
        return this;
    }

    public InternalLogger trace(Supplier<Object> message) {
        if (this.isTraceEnabled()) {
            this.underlyingLogger.trace(message.get().toString());
        }
        return this;
    }

    public InternalLogger trace(Supplier<Object> message, Throwable throwable) {
        if (this.underlyingLogger.isTraceEnabled()) {
            this.underlyingLogger.trace(message.get().toString(), throwable);
        }
        return this;
    }

    public InternalLogger warn(Supplier<Object> message) {
        if (this.underlyingLogger.isWarnEnabled()) {
            this.underlyingLogger.warn(message.get().toString());
        }
        return this;
    }

    public InternalLogger warn(Supplier<Object> message, Throwable throwable) {
        if (this.underlyingLogger.isWarnEnabled()) {
            this.underlyingLogger.warn(message.get().toString(), throwable);
        }
        return this;
    }

    public InternalLogger error(Supplier<Object> message) {
        if (this.underlyingLogger.isErrorEnabled()) {
            this.underlyingLogger.error(message.get().toString());
        }
        return this;
    }

    public InternalLogger error(Supplier<Object> message, Throwable throwable) {
        if (this.underlyingLogger.isErrorEnabled()) {
            this.underlyingLogger.error(message.get().toString(), throwable);
        }
        return this;
    }

    public InternalLogger log(Level level, Supplier<Object> message) {
        switch (level) {
            case INFO: {
                return this.info(message);
            }
            case ERROR: {
                return this.error(message);
            }
            case WARN: {
                return this.warn(message);
            }
            case DEBUG: {
                return this.debug(message);
            }
            case TRACE: {
                return this.trace(message);
            }
        }
        return this;
    }

    public InternalLogger log(Level level, Supplier<Object> message, Throwable throwable) {
        switch (level) {
            case INFO: {
                return this.info(message, throwable);
            }
            case ERROR: {
                return this.error(message, throwable);
            }
            case WARN: {
                return this.warn(message, throwable);
            }
            case DEBUG: {
                return this.debug(message, throwable);
            }
            case TRACE: {
                return this.trace(message, throwable);
            }
        }
        return this;
    }
}

