/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.oauth2.BaseAuthTokenSupplier;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class GlobalCustomerPasswordTokenSupplier
extends BaseAuthTokenSupplier
implements TokenSupplier {
    public GlobalCustomerPasswordTokenSupplier(String clientId, String clientSecret, String email, String password, String scope, String tokenEndpoint, VrapHttpClient vrapHttpClient) {
        super(vrapHttpClient, GlobalCustomerPasswordTokenSupplier.constructApiHttpRequest(clientId, clientSecret, email, password, scope, tokenEndpoint));
    }

    public GlobalCustomerPasswordTokenSupplier(String clientId, String clientSecret, String email, String password, String scope, String tokenEndpoint, VrapHttpClient vrapHttpClient, ResponseSerializer serializer) {
        super(vrapHttpClient, GlobalCustomerPasswordTokenSupplier.constructApiHttpRequest(clientId, clientSecret, email, password, scope, tokenEndpoint), serializer);
    }

    private static ApiHttpRequest constructApiHttpRequest(String clientId, String clientSecret, String email, String password, String scope, String tokenEndpoint) {
        String auth = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        String body = scope == null || scope.isEmpty() ? String.format("grant_type=password&username=%s&password=%s", GlobalCustomerPasswordTokenSupplier.urlEncode(email), GlobalCustomerPasswordTokenSupplier.urlEncode(password)) : String.format("grant_type=password&username=%s&password=%s&scope=%s", GlobalCustomerPasswordTokenSupplier.urlEncode(email), GlobalCustomerPasswordTokenSupplier.urlEncode(password), GlobalCustomerPasswordTokenSupplier.urlEncode(scope));
        ApiHttpHeaders apiHttpHeaders = new ApiHttpHeaders().withHeader("Authorization", String.format("Basic %s", auth)).withHeader("Content-Type", "application/x-www-form-urlencoded");
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(tokenEndpoint), apiHttpHeaders, body.getBytes(StandardCharsets.UTF_8));
    }
}

