/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.ClassReferenceContext;
import io.vrap.rmf.base.client.ContextApiHttpClient;
import io.vrap.rmf.base.client.ContextAware;
import io.vrap.rmf.base.client.ResponseSerializer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class ContextApiHttpClientImpl
extends AutoCloseableService
implements ContextApiHttpClient {
    private final ApiHttpClient client;
    private final boolean closeHttpClient;
    private Map<Object, Object> contextMap;
    private final Consumer<ContextAware<ContextApiHttpClient>> consumer;

    public ContextApiHttpClientImpl(ApiHttpClient client) {
        this(client, new HashMap<Object, Object>(), null);
    }

    public ContextApiHttpClientImpl(ApiHttpClient client, Map<Object, Object> contextMap) {
        this(client, contextMap, null);
    }

    public ContextApiHttpClientImpl(ApiHttpClient client, Map<Object, Object> contextMap, Consumer<ContextAware<ContextApiHttpClient>> consumer) {
        this(client, contextMap, consumer, true);
    }

    public ContextApiHttpClientImpl(ApiHttpClient client, boolean closeHttpClient) {
        this(client, new HashMap<Object, Object>(), null, closeHttpClient);
    }

    public ContextApiHttpClientImpl(ApiHttpClient client, Map<Object, Object> contextMap, boolean closeHttpClient) {
        this(client, contextMap, null, closeHttpClient);
    }

    public ContextApiHttpClientImpl(ApiHttpClient client, Map<Object, Object> contextMap, Consumer<ContextAware<ContextApiHttpClient>> consumer, boolean closeHttpClient) {
        this.client = client;
        this.contextMap = contextMap;
        this.consumer = consumer;
        this.closeHttpClient = closeHttpClient;
    }

    public ContextApiHttpClientImpl(ContextApiHttpClientImpl c) {
        this.client = c.client;
        this.contextMap = c.contextMap;
        this.consumer = c.consumer;
        this.closeHttpClient = c.closeHttpClient;
    }

    @Override
    public Map<Object, Object> getContextMap() {
        return this.contextMap;
    }

    @Override
    public ContextApiHttpClient withContextMap(Map<Object, Object> contextMap) {
        ContextApiHttpClientImpl client = this.copy();
        client.contextMap = new HashMap<Object, Object>(contextMap);
        return client;
    }

    @Override
    public <T> T getContext(Class<T> key) {
        return (T)this.contextMap.get(key);
    }

    @Override
    public <T> ContextApiHttpClient addContext(T value) {
        ContextApiHttpClientImpl client = this.copy();
        HashMap<Object, Object> contextMap = new HashMap<Object, Object>(client.contextMap);
        contextMap.put(value.getClass(), value);
        if (value instanceof ClassReferenceContext) {
            contextMap.put(((ClassReferenceContext)value).classReference(), value);
        }
        client.contextMap = contextMap;
        return client;
    }

    @Override
    public Object getContext(Object key) {
        return this.contextMap.get(key);
    }

    @Override
    public ContextApiHttpClient addContext(Object key, Object value) {
        ContextApiHttpClientImpl client = this.copy();
        HashMap<Object, Object> contextMap = new HashMap<Object, Object>(client.contextMap);
        contextMap.put(key, value);
        client.contextMap = contextMap;
        return client;
    }

    private ContextApiHttpClientImpl copy() {
        return new ContextApiHttpClientImpl(this);
    }

    private void restoreContext() {
        Optional.ofNullable(this.consumer).ifPresent(c -> c.accept(this));
    }

    @Override
    public ResponseSerializer getSerializerService() {
        return this.client.getSerializerService();
    }

    @Override
    public URI getBaseUri() {
        return this.client.getBaseUri();
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        this.restoreContext();
        return this.client.execute((ApiHttpRequest)request.withContextMap((Map)this.contextMap));
    }

    @Override
    protected void internalClose() {
        if (this.closeHttpClient) {
            ContextApiHttpClientImpl.closeQuietly(this.client);
        }
        this.contextMap.values().forEach(o -> {
            if (o instanceof AutoCloseable) {
                ContextApiHttpClientImpl.closeQuietly((AutoCloseable)o);
            }
        });
    }
}

