/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.error.HttpExceptionFactory;
import io.vrap.rmf.base.client.http.ErrorMiddleware;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;

class ErrorMiddlewareImpl
implements ErrorMiddleware {
    private final HttpExceptionFactory exceptionFactory;
    private final ErrorMiddleware.ExceptionMode exceptionMode;

    @Deprecated
    public ErrorMiddlewareImpl(ResponseSerializer serializer) {
        this(HttpExceptionFactory.of(serializer));
    }

    public ErrorMiddlewareImpl(HttpExceptionFactory exceptionFactory) {
        this(exceptionFactory, ErrorMiddleware.ExceptionMode.COMPLETION_EXCEPTION);
    }

    public ErrorMiddlewareImpl(HttpExceptionFactory exceptionFactory, ErrorMiddleware.ExceptionMode mode) {
        this.exceptionFactory = exceptionFactory;
        this.exceptionMode = mode;
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        if (this.exceptionMode == ErrorMiddleware.ExceptionMode.COMPLETION_EXCEPTION) {
            return next.apply(request).thenApply(response -> {
                if (response.getStatusCode() >= 400) {
                    throw this.exceptionFactory.create(request, (ApiHttpResponse<byte[]>)response);
                }
                return response;
            });
        }
        CompletableFuture<ApiHttpResponse<byte[]>> result = new CompletableFuture<ApiHttpResponse<byte[]>>();
        next.apply(request).whenComplete((response, throwable) -> {
            if (throwable != null) {
                Throwable unwrap = throwable instanceof CompletionException ? throwable.getCause() : throwable;
                result.completeExceptionally(unwrap);
            }
            if (response != null && response.getStatusCode() >= 400) {
                try {
                    result.completeExceptionally(this.exceptionFactory.create(request, (ApiHttpResponse<byte[]>)response));
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
            result.complete((ApiHttpResponse<byte[]>)response);
        });
        return result;
    }
}

