/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.VrapHttpClient;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class HttpHandler
extends AutoCloseableService
implements VrapHttpClient {
    private final VrapHttpClient httpClient;

    public HttpHandler(VrapHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static HttpHandler create(VrapHttpClient httpClient) {
        return new HttpHandler(httpClient);
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest apiHttpRequest) {
        return this.httpClient.execute(apiHttpRequest).thenApply(response -> response.withContextMap((Map)apiHttpRequest.getContextMap()));
    }

    @Override
    protected void internalClose() {
        if (this.httpClient instanceof AutoCloseable) {
            HttpHandler.closeQuietly((AutoCloseable)((Object)this.httpClient));
        }
    }
}

