/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.oauth2.BaseAuthTokenSupplier;
import io.vrap.rmf.base.client.oauth2.RefreshFlowTokenSupplier;
import io.vrap.rmf.base.client.oauth2.RefreshableTokenSupplier;
import io.vrap.rmf.base.client.utils.ClientUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;

public class AnonymousFlowTokenSupplier
extends BaseAuthTokenSupplier
implements RefreshableTokenSupplier {
    private final RefreshFlowTokenSupplier refreshFlowTokenSupplier;

    public AnonymousFlowTokenSupplier(String clientId, String clientSecret, String scope, String tokenEndpoint, RefreshFlowTokenSupplier refreshFlowTokenSupplier, VrapHttpClient vrapHttpClient) {
        super(vrapHttpClient, AnonymousFlowTokenSupplier.constructApiHttpRequest(clientId, clientSecret, scope, tokenEndpoint));
        this.refreshFlowTokenSupplier = refreshFlowTokenSupplier;
    }

    public AnonymousFlowTokenSupplier(String clientId, String clientSecret, String scope, String tokenEndpoint, RefreshFlowTokenSupplier refreshFlowTokenSupplier, VrapHttpClient vrapHttpClient, ResponseSerializer serializer) {
        super(vrapHttpClient, AnonymousFlowTokenSupplier.constructApiHttpRequest(clientId, clientSecret, scope, tokenEndpoint), serializer);
        this.refreshFlowTokenSupplier = refreshFlowTokenSupplier;
    }

    @Override
    public CompletableFuture<AuthenticationToken> refreshToken() {
        return this.refreshFlowTokenSupplier.refreshToken().exceptionally(throwable -> {
            this.logger.error(() -> throwable);
            return ClientUtils.blockingWait(this.getToken(), Duration.ofSeconds(5L));
        });
    }

    private static ApiHttpRequest constructApiHttpRequest(String clientId, String clientSecret, String scope, String tokenEndpoint) {
        String auth = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        ApiHttpHeaders apiHttpHeaders = new ApiHttpHeaders(ApiHttpHeaders.headerEntry("Authorization", String.format("Basic %s", auth)), ApiHttpHeaders.headerEntry("Content-Type", "application/x-www-form-urlencoded"));
        String body = scope == null || scope.isEmpty() ? "grant_type=client_credentials" : String.format("grant_type=client_credentials&scope=%s", AnonymousFlowTokenSupplier.urlEncode(scope));
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(tokenEndpoint), apiHttpHeaders, body.getBytes(StandardCharsets.UTF_8));
    }
}

