/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.InternalLoggerMiddleware;
import io.vrap.rmf.base.client.utils.json.JsonException;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

class InternalLoggerMiddlewareImpl
implements InternalLoggerMiddleware {
    private static final Logger classLogger = LoggerFactory.getLogger(InternalLoggerMiddlewareImpl.class);
    private final InternalLoggerFactory factory;
    private final Level deprecationLogEvent;
    private final Level responseLogEvent;

    public InternalLoggerMiddlewareImpl(InternalLoggerFactory factory) {
        this(factory, Level.INFO, Level.INFO);
    }

    public InternalLoggerMiddlewareImpl(InternalLoggerFactory factory, Level responseLogEvent, Level deprecationLogEvent) {
        this.factory = factory;
        this.responseLogEvent = responseLogEvent;
        this.deprecationLogEvent = deprecationLogEvent;
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        InternalLogger logger = this.factory.createFor(request, "request");
        logger.debug(() -> request);
        logger.trace(() -> {
            String output;
            String httpMethodAndUrl = request.getMethod().name() + " " + request.getUrl().toString();
            if (request.getBody() != null) {
                String unformattedBody = request.getSecuredBody();
                boolean isJsonRequest = request.getHeaders().getHeaders("Content-Type").stream().findFirst().map(ct -> ((String)ct.getValue()).toLowerCase().contains("json")).orElse(true);
                if (isJsonRequest) {
                    String prettyPrint;
                    try {
                        prettyPrint = JsonUtils.prettyPrint(unformattedBody);
                    }
                    catch (JsonException e) {
                        classLogger.warn("pretty print failed", (Throwable)e);
                        prettyPrint = unformattedBody;
                    }
                    output = "send: " + httpMethodAndUrl + "\nformatted: " + prettyPrint;
                } else {
                    output = "send: " + request.getMethod().name() + " " + request.getUrl() + " " + unformattedBody;
                }
            } else {
                output = httpMethodAndUrl + " <no body>";
            }
            return output;
        });
        return next.apply(request).whenComplete((response, throwable) -> {
            InternalLogger responseLogger = this.factory.createFor(request, "response");
            if (throwable != null) {
                if (throwable.getCause() instanceof ApiHttpException) {
                    ApiHttpResponse<byte[]> errorResponse = ((ApiHttpException)throwable.getCause()).getResponse();
                    responseLogger.error(() -> String.format("%s %s %s", request.getMethod().name(), request.getUrl(), errorResponse.getStatusCode()));
                    List<Map.Entry<String, String>> notices = errorResponse.getHeaders().getHeaders("X-Deprecation-Notice");
                    if (notices != null) {
                        notices.forEach(message -> logger.log(this.deprecationLogEvent, () -> "Deprecation notice: " + message));
                    }
                    responseLogger.debug(() -> errorResponse, (Throwable)throwable);
                    responseLogger.trace(() -> errorResponse.getStatusCode() + "\n" + Optional.ofNullable(errorResponse.getBody()).map(body -> JsonUtils.prettyPrint(errorResponse.getBodyAsString().orElse(""))).orElse("<no body>"));
                } else {
                    responseLogger.error(throwable::getCause, (Throwable)throwable);
                }
            } else {
                responseLogger.log(this.responseLogEvent, () -> String.format("%s %s %s", request.getMethod().name(), request.getUrl(), response.getStatusCode()));
                List<Map.Entry<String, String>> notices = response.getHeaders().getHeaders("X-Deprecation-Notice");
                if (notices != null) {
                    notices.forEach(message -> logger.log(this.deprecationLogEvent, () -> "Deprecation notice: " + message));
                }
                responseLogger.debug(() -> response);
                responseLogger.trace(() -> response.getStatusCode() + "\n" + Optional.ofNullable(response.getBody()).map(body -> JsonUtils.prettyPrint(response.getBodyAsString().orElse(""))).orElse("<no body>"));
            }
        });
    }
}

