/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.oauth2.RefreshableTokenSupplier;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.Timeout;

public class InMemoryTokenSupplier
extends AutoCloseableService
implements RefreshableTokenSupplier {
    private final TokenSupplier supplier;
    private final Object lock = new Object();
    private volatile CompletableFuture<AuthenticationToken> tokenFuture;
    private final FailsafeExecutor<AuthenticationToken> failsafeExecutor;

    public InMemoryTokenSupplier(TokenSupplier tokenSupplier) {
        this.supplier = tokenSupplier;
        this.failsafeExecutor = Failsafe.with((Policy)Timeout.of((Duration)Duration.ofSeconds(10L)), (Policy[])new Timeout[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AuthenticationToken> getToken() {
        if (this.tokenFuture == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.tokenFuture == null) {
                    this.failsafeExecutor.run(() -> {
                        this.tokenFuture = CompletableFuture.completedFuture(this.supplier.getToken().join());
                    });
                }
            }
        }
        return this.tokenFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<AuthenticationToken> refreshToken() {
        Object object = this.lock;
        synchronized (object) {
            this.tokenFuture = null;
        }
        return this.getToken();
    }

    @Override
    protected void internalClose() {
        if (this.supplier instanceof AutoCloseable) {
            InMemoryTokenSupplier.closeQuietly((AutoCloseable)((Object)this.supplier));
        }
    }
}

