/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.oauth2;

import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpMethod;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.oauth2.AuthException;
import io.vrap.rmf.base.client.oauth2.BaseAuthTokenSupplier;
import io.vrap.rmf.base.client.oauth2.RefreshableTokenSupplier;
import io.vrap.rmf.base.client.oauth2.TokenStorage;
import io.vrap.rmf.base.client.utils.Utils;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class RefreshFlowTokenSupplier
extends BaseAuthTokenSupplier
implements RefreshableTokenSupplier {
    private final TokenStorage tokenStorage;

    public RefreshFlowTokenSupplier(String clientId, String clientSecret, String tokenEndpoint, TokenStorage tokenStorage, VrapHttpClient vrapHttpClient) {
        super(vrapHttpClient, RefreshFlowTokenSupplier.constructApiHttpRequest(clientId, clientSecret, tokenEndpoint));
        this.tokenStorage = tokenStorage;
    }

    @Override
    public CompletableFuture<AuthenticationToken> refreshToken() {
        AuthenticationToken token = this.tokenStorage.getToken();
        if (token.getRefreshToken() == null) {
            throw new AuthException(400, "No refresh_token given", null);
        }
        String body = String.format("grant_type=refresh_token&refresh_token=%s", RefreshFlowTokenSupplier.urlEncode(token.getRefreshToken()));
        ApiHttpRequest request = this.apiHttpRequest.withBody(body);
        this.logger.debug(() -> request);
        return ((CompletableFuture)((CompletableFuture)this.vrapHttpClient.execute(request).whenComplete((response, throwable) -> {
            this.logger.info(() -> String.format("%s %s %s", this.apiHttpRequest.getMethod().name(), this.apiHttpRequest.getUri(), response.getStatusCode()));
            if (throwable != null) {
                this.logger.error(() -> response, (Throwable)throwable);
            } else {
                this.logger.debug(() -> response);
            }
        })).thenApply(apiHttpResponse -> {
            if (apiHttpResponse.getStatusCode() < 200 || apiHttpResponse.getStatusCode() > 299) {
                throw new CompletionException(new Throwable(new String((byte[])apiHttpResponse.getBody())));
            }
            return apiHttpResponse;
        })).thenApply(Utils.wrapToCompletionException(response -> JsonUtils.fromJsonByteArray((byte[])response.getBody(), AuthenticationToken.class)));
    }

    @Override
    public CompletableFuture<AuthenticationToken> getToken() {
        return this.refreshToken();
    }

    private static ApiHttpRequest constructApiHttpRequest(String clientId, String clientSecret, String tokenEndpoint) {
        String auth = Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes(StandardCharsets.UTF_8));
        ApiHttpHeaders apiHttpHeaders = new ApiHttpHeaders(ApiHttpHeaders.headerEntry("Authorization", String.format("Basic %s", auth)), ApiHttpHeaders.headerEntry("Content-Type", "application/x-www-form-urlencoded"));
        return new ApiHttpRequest(ApiHttpMethod.POST, URI.create(tokenEndpoint), apiHttpHeaders, null);
    }
}

