/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.HttpClientSupplier;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.ServiceRegionConfig;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.error.HttpExceptionFactory;
import io.vrap.rmf.base.client.http.AcceptGZipMiddleware;
import io.vrap.rmf.base.client.http.CorrelationIdProvider;
import io.vrap.rmf.base.client.http.ErrorMiddleware;
import io.vrap.rmf.base.client.http.HandlerStack;
import io.vrap.rmf.base.client.http.HttpHandler;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.InternalLoggerFactory;
import io.vrap.rmf.base.client.http.InternalLoggerMiddleware;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.OAuthHandler;
import io.vrap.rmf.base.client.http.OAuthMiddleware;
import io.vrap.rmf.base.client.http.RetryMiddleware;
import io.vrap.rmf.base.client.http.UserAgentMiddleware;
import io.vrap.rmf.base.client.oauth2.AnonymousFlowTokenSupplier;
import io.vrap.rmf.base.client.oauth2.AnonymousSessionTokenSupplier;
import io.vrap.rmf.base.client.oauth2.ClientCredentials;
import io.vrap.rmf.base.client.oauth2.ClientCredentialsTokenSupplier;
import io.vrap.rmf.base.client.oauth2.GlobalCustomerPasswordTokenSupplier;
import io.vrap.rmf.base.client.oauth2.InMemoryTokenSupplier;
import io.vrap.rmf.base.client.oauth2.RefreshFlowTokenSupplier;
import io.vrap.rmf.base.client.oauth2.StaticTokenSupplier;
import io.vrap.rmf.base.client.oauth2.TokenStorage;
import io.vrap.rmf.base.client.oauth2.TokenStorageSupplier;
import io.vrap.rmf.base.client.oauth2.TokenSupplier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.event.Level;

public class ClientBuilder
implements Builder<ApiHttpClient> {
    public static final String COMMERCETOOLS = "commercetools";
    static final String userAgent = "commercetools-sdk-java-v2/";
    private URI apiBaseUrl;
    private boolean useAuthCircuitBreaker;
    private int authRetries;
    private Supplier<ErrorMiddleware> errorMiddleware;
    private Supplier<OAuthMiddleware> oAuthMiddleware;
    private Supplier<RetryMiddleware> retryMiddleware;
    private Supplier<Middleware> correlationIdMiddleware;
    private InternalLoggerMiddleware internalLoggerMiddleware;
    private UserAgentMiddleware userAgentMiddleware;
    private List<Middleware> middlewares = new ArrayList<Middleware>();
    private Supplier<HandlerStack> stack;
    private VrapHttpClient httpClient;
    private VrapHttpClient oauthHttpClient;
    private Supplier<ResponseSerializer> serializer;
    private Supplier<HttpExceptionFactory> httpExceptionFactory;

    public static ClientBuilder of() {
        return new ClientBuilder();
    }

    public static ClientBuilder of(VrapHttpClient httpClient) {
        return new ClientBuilder(httpClient);
    }

    public static ClientBuilder of(ApiHttpClient httpClient) {
        return new ClientBuilder(httpClient);
    }

    public static ClientBuilder of(HandlerStack stack) {
        return new ClientBuilder(stack);
    }

    private ClientBuilder(HandlerStack stack) {
        this.stack = () -> stack;
        ResponseSerializer serializer = ResponseSerializer.of();
        this.serializer = () -> serializer;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.useAuthCircuitBreaker = false;
        this.authRetries = 1;
    }

    private ClientBuilder() {
        this.oauthHttpClient = this.httpClient = HttpClientSupplier.of().get();
        this.stack = this.stackSupplier();
        ResponseSerializer serializer = ResponseSerializer.of();
        this.serializer = () -> serializer;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.useAuthCircuitBreaker = false;
        this.authRetries = 1;
    }

    private ClientBuilder(ApiHttpClient httpClient) {
        this.httpClient = httpClient;
        this.oauthHttpClient = HttpClientSupplier.of().get();
        this.stack = this.stackSupplier();
        ResponseSerializer serializer = ResponseSerializer.of();
        this.serializer = () -> serializer;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.authRetries = 1;
    }

    private ClientBuilder(VrapHttpClient httpClient) {
        this.httpClient = httpClient;
        this.oauthHttpClient = httpClient;
        this.stack = this.stackSupplier();
        ResponseSerializer serializer = ResponseSerializer.of();
        this.serializer = () -> serializer;
        this.httpExceptionFactory = () -> HttpExceptionFactory.of(this.serializer.get());
        this.authRetries = 1;
    }

    private Supplier<HandlerStack> stackSupplier() {
        return () -> {
            ArrayList<Middleware> middlewareStack = new ArrayList<Middleware>();
            Optional.ofNullable(this.errorMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.internalLoggerMiddleware).map(middlewareStack::add);
            Optional.ofNullable(this.userAgentMiddleware).map(middlewareStack::add);
            Optional.ofNullable(this.oAuthMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.retryMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            Optional.ofNullable(this.correlationIdMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            middlewareStack.addAll(this.middlewares);
            return HandlerStack.create(HttpHandler.create(Objects.requireNonNull(this.httpClient)), middlewareStack);
        };
    }

    private Supplier<HandlerStack> oauthHandlerSupplier() {
        return () -> {
            ArrayList<Middleware> middlewareStack = new ArrayList<Middleware>();
            Optional.ofNullable(this.userAgentMiddleware).map(middlewareStack::add);
            Optional.ofNullable(this.correlationIdMiddleware).map(m -> middlewareStack.add((Middleware)m.get()));
            return HandlerStack.create(HttpHandler.create(Objects.requireNonNull(this.oauthHttpClient)), middlewareStack);
        };
    }

    public ClientBuilder withoutAuthCircuitBreaker() {
        this.useAuthCircuitBreaker = false;
        return this;
    }

    public ClientBuilder withAuthCircuitBreaker() {
        this.useAuthCircuitBreaker = true;
        return this;
    }

    public ClientBuilder withAuthRetries(int authRetries) {
        this.authRetries = authRetries;
        return this;
    }

    public ClientBuilder withHandlerStack(HandlerStack stack) {
        this.stack = () -> stack;
        return this;
    }

    public ClientBuilder withHttpClient(VrapHttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ClientBuilder withOAuthHttpClient(VrapHttpClient httpClient) {
        this.oauthHttpClient = httpClient;
        return this;
    }

    public ClientBuilder withSerializer(ResponseSerializer serializer) {
        this.serializer = () -> serializer;
        return this;
    }

    public ClientBuilder withSerializer(Supplier<ResponseSerializer> serializer) {
        this.serializer = serializer;
        return this;
    }

    public ClientBuilder withHttpExceptionFactory(HttpExceptionFactory factory) {
        this.httpExceptionFactory = () -> factory;
        return this;
    }

    public ClientBuilder withHttpExceptionFactory(Function<ResponseSerializer, HttpExceptionFactory> factory) {
        this.httpExceptionFactory = () -> (HttpExceptionFactory)factory.apply(this.serializer.get());
        return this;
    }

    public ClientBuilder withHttpExceptionFactory(Supplier<HttpExceptionFactory> factory) {
        this.httpExceptionFactory = factory;
        return this;
    }

    public ClientBuilder defaultClient(URI apiBaseUrl) {
        return this.withApiBaseUrl(apiBaseUrl).withErrorMiddleware().withSerializer(ResponseSerializer.of()).withInternalLoggerFactory((request, topic) -> InternalLogger.getLogger("commercetools." + topic)).withUserAgentSupplier(ClientBuilder::buildDefaultUserAgent).addAcceptGZipMiddleware();
    }

    public ClientBuilder defaultClient(String apiBaseUrl) {
        return this.defaultClient(URI.create(apiBaseUrl));
    }

    public ClientBuilder defaultClient(String apiBaseUrl, ClientCredentials credentials, String tokenEndpoint) {
        return this.defaultClient(apiBaseUrl).withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    public ClientBuilder defaultClient(ClientCredentials credentials, ServiceRegionConfig serviceRegionConfig) {
        return this.defaultClient(serviceRegionConfig.getApiUrl()).withClientCredentialsFlow(credentials, serviceRegionConfig.getOAuthTokenUrl());
    }

    @Deprecated
    public ClientBuilder withClientCredentials(ClientCredentials credentials, String tokenEndpoint) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint);
    }

    @Deprecated
    public ClientBuilder withClientCredentials(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint, httpClient);
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint.toString());
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint.toString(), httpClientSupplier);
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, URI tokenEndpoint, VrapHttpClient httpClient) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint.toString(), httpClient);
    }

    private TokenSupplier createClientCredentialsTokenSupplier(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return new ClientCredentialsTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), credentials.getScopes(), tokenEndpoint, httpClient);
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint) {
        return this.withClientCredentialsFlow(credentials, tokenEndpoint, this.oauthHandlerSupplier());
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createClientCredentialsTokenSupplier(credentials, tokenEndpoint, (VrapHttpClient)httpClientSupplier.get())));
    }

    public ClientBuilder withClientCredentialsFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createClientCredentialsTokenSupplier(credentials, tokenEndpoint, httpClient)));
    }

    public ClientBuilder withStaticTokenFlow(AuthenticationToken token) {
        return this.withTokenSupplier(new StaticTokenSupplier(token));
    }

    public ClientBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint) {
        return this.withAnonymousSessionFlow(credentials, tokenEndpoint, this.oauthHandlerSupplier());
    }

    public ClientBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createAnonymousSessionTokenSupplier(credentials, tokenEndpoint, (VrapHttpClient)httpClientSupplier.get())));
    }

    public ClientBuilder withAnonymousSessionFlow(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createAnonymousSessionTokenSupplier(credentials, tokenEndpoint, httpClient)));
    }

    private TokenSupplier createAnonymousSessionTokenSupplier(ClientCredentials credentials, String tokenEndpoint, VrapHttpClient httpClient) {
        return new AnonymousSessionTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), credentials.getScopes(), tokenEndpoint, httpClient);
    }

    public ClientBuilder withAnonymousRefreshFlow(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage storage) {
        return this.withAnonymousRefreshFlow(credentials, anonTokenEndpoint, refreshTokenEndpoint, storage, this.oauthHandlerSupplier());
    }

    public ClientBuilder withAnonymousRefreshFlow(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage storage, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createAnonymousRefreshFlowSupplier(credentials, anonTokenEndpoint, refreshTokenEndpoint, storage, (VrapHttpClient)httpClientSupplier.get()));
    }

    public ClientBuilder withAnonymousRefreshFlow(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage storage, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createAnonymousRefreshFlowSupplier(credentials, anonTokenEndpoint, refreshTokenEndpoint, storage, httpClient));
    }

    private TokenSupplier createInMemoryTokenSupplier(TokenSupplier tokenSupplier) {
        return new InMemoryTokenSupplier(tokenSupplier);
    }

    private TokenSupplier createAnonymousRefreshFlowSupplier(ClientCredentials credentials, String anonTokenEndpoint, String refreshTokenEndpoint, TokenStorage tokenStorage, VrapHttpClient httpClient) {
        RefreshFlowTokenSupplier refreshFlowTokenSupplier = this.createRefreshFlowSupplier(credentials, refreshTokenEndpoint, tokenStorage, httpClient);
        AnonymousFlowTokenSupplier anonymousFlowTokenSupplier = new AnonymousFlowTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), credentials.getScopes(), anonTokenEndpoint, refreshFlowTokenSupplier, httpClient);
        return new TokenStorageSupplier(tokenStorage, anonymousFlowTokenSupplier);
    }

    private RefreshFlowTokenSupplier createRefreshFlowSupplier(ClientCredentials credentials, String tokenEndpoint, TokenStorage tokenStorage, VrapHttpClient httpClient) {
        return new RefreshFlowTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), tokenEndpoint, tokenStorage, httpClient);
    }

    public ClientBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint) {
        return this.withGlobalCustomerPasswordFlow(credentials, email, password, tokenEndpoint, this.oauthHandlerSupplier());
    }

    public ClientBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint, Supplier<HandlerStack> httpClientSupplier) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createGlobalCustomerPasswordTokenSupplier(credentials, email, password, tokenEndpoint, (VrapHttpClient)httpClientSupplier.get())));
    }

    public ClientBuilder withGlobalCustomerPasswordFlow(ClientCredentials credentials, String email, String password, String tokenEndpoint, VrapHttpClient httpClient) {
        return this.withTokenSupplier(() -> this.createInMemoryTokenSupplier(this.createGlobalCustomerPasswordTokenSupplier(credentials, email, password, tokenEndpoint, httpClient)));
    }

    private TokenSupplier createGlobalCustomerPasswordTokenSupplier(ClientCredentials credentials, String email, String password, String tokenEndpoint, VrapHttpClient httpClient) {
        return new GlobalCustomerPasswordTokenSupplier(credentials.getClientId(), credentials.getClientSecret(), email, password, credentials.getScopes(), tokenEndpoint, httpClient);
    }

    public ClientBuilder addAcceptGZipMiddleware() {
        return this.addMiddleware(AcceptGZipMiddleware.of(), new Middleware[0]);
    }

    public ClientBuilder withErrorMiddleware(Supplier<ErrorMiddleware> errorMiddleware) {
        this.errorMiddleware = errorMiddleware;
        return this;
    }

    public ClientBuilder withErrorMiddleware() {
        return this.withErrorMiddleware(() -> ErrorMiddleware.of(this.httpExceptionFactory.get()));
    }

    public ClientBuilder withErrorMiddleware(ErrorMiddleware errorMiddleware) {
        return this.withErrorMiddleware(() -> errorMiddleware);
    }

    public ClientBuilder withRetryMiddleware(Supplier<RetryMiddleware> retryMiddleware) {
        this.retryMiddleware = retryMiddleware;
        return this;
    }

    public ClientBuilder withRetryMiddleware(RetryMiddleware retryMiddleware) {
        return this.withRetryMiddleware(() -> retryMiddleware);
    }

    public ClientBuilder withRetryMiddleware(int maxRetries) {
        return this.withRetryMiddleware(new RetryMiddleware(maxRetries));
    }

    public ClientBuilder withRetryMiddleware(int maxRetries, List<Integer> statusCodes) {
        return this.withRetryMiddleware(new RetryMiddleware(maxRetries, statusCodes));
    }

    public ClientBuilder withOAuthMiddleware(Supplier<OAuthMiddleware> oAuthMiddleware) {
        this.oAuthMiddleware = oAuthMiddleware;
        return this;
    }

    public ClientBuilder withOAuthMiddleware(OAuthMiddleware oAuthMiddleware) {
        return this.withOAuthMiddleware(() -> oAuthMiddleware);
    }

    public ClientBuilder withTokenSupplier(Supplier<TokenSupplier> tokenSupplier) {
        return this.withOAuthMiddleware(() -> {
            OAuthHandler oAuthHandler = new OAuthHandler((TokenSupplier)tokenSupplier.get());
            return OAuthMiddleware.of(oAuthHandler, this.authRetries, this.useAuthCircuitBreaker);
        });
    }

    public ClientBuilder withTokenSupplier(TokenSupplier tokenSupplier) {
        return this.withTokenSupplier(() -> tokenSupplier);
    }

    public ClientBuilder withInternalLoggerMiddleware(InternalLoggerMiddleware internalLoggerMiddleware) {
        this.internalLoggerMiddleware = internalLoggerMiddleware;
        return this;
    }

    public ClientBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory) {
        return this.withInternalLoggerMiddleware(InternalLoggerMiddleware.of(internalLoggerFactory));
    }

    public ClientBuilder withInternalLoggerFactory(InternalLoggerFactory internalLoggerFactory, Level responseLogEvent, Level deprecationLogEvent) {
        return this.withInternalLoggerMiddleware(InternalLoggerMiddleware.of(internalLoggerFactory, responseLogEvent, deprecationLogEvent));
    }

    public ClientBuilder withApiBaseUrl(String apiBaseUrl) {
        return this.withApiBaseUrl(URI.create(apiBaseUrl));
    }

    public ClientBuilder withApiBaseUrl(URI apiBaseUrl) {
        this.apiBaseUrl = apiBaseUrl;
        return this;
    }

    public ClientBuilder withUserAgentSupplier(Supplier<String> userAgentSupplier) {
        return this.withUserAgentMiddleware(new UserAgentMiddleware(userAgentSupplier.get()));
    }

    private ClientBuilder withUserAgentMiddleware(UserAgentMiddleware userAgentMiddleware) {
        this.userAgentMiddleware = userAgentMiddleware;
        return this;
    }

    public ClientBuilder addCorrelationIdProvider(@Nullable CorrelationIdProvider correlationIdProvider) {
        if (correlationIdProvider != null) {
            this.correlationIdMiddleware = () -> (request, next) -> {
                if (request.getHeaders().getFirst("X-Correlation-ID") != null) {
                    return (CompletableFuture)next.apply(request);
                }
                return (CompletableFuture)next.apply(request.withHeader("X-Correlation-ID", correlationIdProvider.getCorrelationId()));
            };
        }
        return this;
    }

    public ClientBuilder withMiddlewares(List<Middleware> middlewares) {
        this.middlewares = new ArrayList<Middleware>(middlewares);
        return this;
    }

    public ClientBuilder withMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.middlewares = new ArrayList<Middleware>(Collections.singletonList(middleware));
        if (middlewares.length > 0) {
            this.middlewares.addAll(Arrays.asList(middlewares));
        }
        return this;
    }

    public ClientBuilder addMiddlewares(List<Middleware> middlewares) {
        this.middlewares.addAll(middlewares);
        return this;
    }

    public ClientBuilder addMiddleware(Middleware middleware, Middleware ... middlewares) {
        this.middlewares.add(middleware);
        if (middlewares.length > 0) {
            this.middlewares.addAll(Arrays.asList(middlewares));
        }
        return this;
    }

    @Override
    public ApiHttpClient build() {
        return ApiHttpClient.of(Objects.requireNonNull(this.apiBaseUrl), Objects.requireNonNull(this.stack.get()), Objects.requireNonNull(this.serializer.get()));
    }

    public static String buildDefaultUserAgent() {
        String runtimeVersion = SystemUtils.JAVA_RUNTIME_VERSION;
        String osName = SystemUtils.OS_NAME;
        String osArch = SystemUtils.OS_ARCH;
        String sdkVersion = "7.6.2";
        return userAgent + sdkVersion + "  Java/" + runtimeVersion + " (" + osName + "; " + osArch + ")";
    }
}

