/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.error.UnauthorizedException;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.OAuthHandler;
import io.vrap.rmf.base.client.http.OAuthMiddleware;
import io.vrap.rmf.base.client.oauth2.AuthException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.FailurePolicy;
import net.jodah.failsafe.Fallback;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class OAuthMiddlewareImpl
implements AutoCloseable,
OAuthMiddleware {
    private final OAuthHandler authHandler;
    private static final InternalLogger logger = InternalLogger.getLogger("commercetools.auth");
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;

    public OAuthMiddlewareImpl(OAuthHandler oAuthHandler) {
        this(Scheduler.DEFAULT, oAuthHandler, 1, false);
    }

    public OAuthMiddlewareImpl(OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this(Scheduler.DEFAULT, oauthHandler, maxRetries, useCircuitBreaker);
    }

    public OAuthMiddlewareImpl(ScheduledExecutorService executorService, OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this(Scheduler.of((ScheduledExecutorService)executorService), oauthHandler, maxRetries, useCircuitBreaker);
    }

    public OAuthMiddlewareImpl(Executor executor, OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this(Scheduler.of((Executor)executor), oauthHandler, maxRetries, useCircuitBreaker);
    }

    public OAuthMiddlewareImpl(Scheduler scheduler, OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this.authHandler = oauthHandler;
        RetryPolicy retry = ((RetryPolicy)new RetryPolicy().handleIf((response, throwable) -> {
            if (throwable != null) {
                return throwable instanceof UnauthorizedException;
            }
            return response.getStatusCode() == 401;
        })).onRetry(event -> {
            logger.debug(() -> "Refresh Bearer token #" + event.getAttemptCount());
            this.authHandler.refreshToken();
        }).withMaxRetries(maxRetries);
        if (useCircuitBreaker) {
            Fallback fallback = (Fallback)Fallback.ofException(event -> {
                logger.debug(() -> "Convert CircuitBreakerOpenException to AuthException");
                logger.trace(() -> ((ExecutionAttemptedEvent)event).getLastFailure());
                return new AuthException(400, "", null, "Authentication failed", null, event.getLastFailure());
            }).handleIf(throwable -> throwable instanceof CircuitBreakerOpenException);
            CircuitBreaker circuitBreaker = new CircuitBreaker();
            ((CircuitBreaker)((CircuitBreaker)circuitBreaker.handleIf((response, throwable) -> {
                if (throwable.getCause() instanceof AuthException) {
                    return ((AuthException)throwable.getCause()).getResponse().getStatusCode() == 400;
                }
                return response.getStatusCode() == 400;
            })).withDelay((result, failure, context) -> Duration.ofMillis(Math.min(100 * context.getAttemptCount() * context.getAttemptCount(), 15000)))).withFailureThreshold(5, Duration.ofMinutes(1L)).withSuccessThreshold(2).onClose(() -> logger.debug(() -> "The authentication circuit breaker was closed")).onOpen(() -> logger.debug(() -> "The authentication circuit breaker was opened")).onHalfOpen(() -> logger.debug(() -> "The authentication circuit breaker was half-opened")).onFailure(event -> logger.trace(() -> "Authentication failed", event.getFailure()));
            this.failsafeExecutor = Failsafe.with((Policy)fallback, (Policy[])new FailurePolicy[]{retry, circuitBreaker}).with(scheduler);
        } else {
            this.failsafeExecutor = Failsafe.with((Policy)retry, (Policy[])new RetryPolicy[0]).with(scheduler);
        }
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> {
            if (request.getHeaders().getFirst("Authorization") != null) {
                return (CompletionStage)next.apply(request);
            }
            AuthenticationToken token = this.authHandler.getToken();
            return (CompletionStage)next.apply(request.addHeader("Authorization", OAuthHandler.authHeader(token)));
        });
    }

    @Override
    public void close() {
        this.authHandler.close();
    }
}

