/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.utils.json.JsonException;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.FailsafeExecutor;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import net.jodah.failsafe.event.ExecutionAttemptedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryMiddleware
implements Middleware,
AutoCloseable {
    @Deprecated
    public static final int DEFAULT_MAX_PARALLEL_REQUESTS = 2;
    static final String loggerName = "commercetools.retry";
    public static final int DEFAULT_MAX_DELAY = 60000;
    public static final int DEFAULT_INITIAL_DELAY = 200;
    public static final List<Integer> DEFAULT_RETRY_STATUS_CODES = Collections.singletonList(503);
    private static final InternalLogger logger = InternalLogger.getLogger("commercetools.retry");
    private static final Logger classLogger = LoggerFactory.getLogger(RetryMiddleware.class);
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;

    public RetryMiddleware(int maxRetries) {
        this(maxRetries, DEFAULT_RETRY_STATUS_CODES);
    }

    public RetryMiddleware(int maxRetries, List<Integer> statusCodes) {
        this(maxRetries, 200L, 60000L, statusCodes);
    }

    public RetryMiddleware(int maxRetries, long delay, long maxDelay) {
        this(maxRetries, delay, maxDelay, DEFAULT_RETRY_STATUS_CODES);
    }

    public RetryMiddleware(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf((response, throwable) -> {
            if (throwable instanceof ApiHttpException) {
                return statusCodes.contains(((ApiHttpException)throwable).getStatusCode());
            }
            return statusCodes.contains(response.getStatusCode());
        })).withBackoff(delay, maxDelay, ChronoUnit.MILLIS).withJitter(0.25).onRetry(this::logEventFailure).withMaxRetries(maxRetries);
        this.failsafeExecutor = Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]);
    }

    private void logEventFailure(ExecutionAttemptedEvent<ApiHttpResponse<byte[]>> event) {
        int attempt = event.getAttemptCount();
        logger.info(() -> "Retry #" + attempt);
        logger.trace(() -> {
            Throwable failure = event.getLastFailure();
            if (failure instanceof ApiHttpException) {
                ApiHttpException httpException = (ApiHttpException)failure;
                ApiHttpRequest request = httpException.getRequest();
                ApiHttpResponse<byte[]> response = httpException.getResponse();
                if (request != null) {
                    return this.requestLog(attempt, request, response);
                }
            }
            return event.toString();
        });
    }

    private String requestLog(int attempt, ApiHttpRequest request, ApiHttpResponse<?> response) {
        String output;
        String httpMethodAndUrl = request.getMethod().name() + " " + request.getUrl().toString();
        if (request.getBody() != null) {
            String unformattedBody = request.getSecuredBody();
            boolean isJsonRequest = request.getHeaders().getHeaders("Content-Type").stream().findFirst().map(ct -> ((String)ct.getValue()).toLowerCase().contains("json")).orElse(true);
            if (isJsonRequest) {
                String prettyPrint;
                try {
                    prettyPrint = JsonUtils.prettyPrint(unformattedBody);
                }
                catch (JsonException e) {
                    classLogger.warn("pretty print failed", (Throwable)e);
                    prettyPrint = unformattedBody;
                }
                output = "Retry #" + attempt + ": " + request + "\n" + httpMethodAndUrl + "\nformatted: " + prettyPrint;
            } else {
                output = "Retry #" + attempt + ": " + request + "\n" + request.getMethod().name() + " " + request.getUrl() + " " + unformattedBody;
            }
        } else {
            output = "Retry #" + attempt + ": " + request + "\n" + httpMethodAndUrl + " <no body>";
        }
        if (response != null) {
            output = output + "\nFailure response: " + response.getStatusCode() + "\n" + response + "\n" + Optional.ofNullable(response.getBody()).map(body -> JsonUtils.prettyPrint(response.getBodyAsString().orElse(""))).orElse("<no body>");
        }
        return output;
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries) {
        this(maxRetries, DEFAULT_RETRY_STATUS_CODES);
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries, List<Integer> statusCodes) {
        this(maxRetries, 200L, 60000L, statusCodes);
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries, long delay, long maxDelay) {
        this(maxRetries, delay, maxDelay, DEFAULT_RETRY_STATUS_CODES);
    }

    @Deprecated
    public RetryMiddleware(int maxParallelRequests, int maxRetries, long delay, long maxDelay, List<Integer> statusCodes) {
        this(maxRetries, delay, maxDelay, statusCodes);
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> (CompletableFuture)next.apply(request));
    }

    @Override
    public void close() {
    }
}

