/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.utils;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.error.RmfTimeoutException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClientUtils {
    public static <T> T blockingWait(CompletionStage<T> completionStage, ApiHttpRequest request, Duration duration) {
        return ClientUtils.blockingWait(completionStage, request, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static <T> T blockingWait(CompletionStage<T> completionStage, Duration duration) {
        return ClientUtils.blockingWait(completionStage, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static <T> T blockingWait(CompletionStage<T> completionStage, long timeout, TimeUnit unit) {
        return ClientUtils.blockingWait(completionStage, null, timeout, unit);
    }

    public static <T> T blockingWait(CompletionStage<T> completionStage, ApiHttpRequest request, long timeout, TimeUnit unit) {
        try {
            return completionStage.toCompletableFuture().get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            Exception cause = e.getCause() != null && e instanceof ExecutionException ? e.getCause() : e;
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new CompletionException(cause);
        }
        catch (TimeoutException e) {
            throw new RmfTimeoutException(e, request);
        }
    }

    public static <T> List<T> blockingWaitForEach(Stream<? extends CompletionStage<T>> stream, Duration duration) {
        return ClientUtils.blockingWaitForEach(stream, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static <T> List<T> blockingWaitForEach(Stream<? extends CompletionStage<T>> stream, long timeout, TimeUnit unit) {
        return stream.map(stage -> ClientUtils.blockingWait(stage, timeout, unit)).collect(Collectors.toList());
    }

    public static <T> List<T> blockingWaitForEach(List<? extends CompletionStage<T>> list, Duration duration) {
        return ClientUtils.blockingWaitForEach(list, duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static <T> List<T> blockingWaitForEach(List<? extends CompletionStage<T>> list, long timeout, TimeUnit unit) {
        return ClientUtils.blockingWaitForEach(list.stream(), timeout, unit);
    }

    public static <S extends CompletionStage<T>, T> Collector<S, ?, List<T>> blockingWaitForEachCollector(long timeout, TimeUnit unit) {
        Function<CompletionStage, Object> mapper = stage -> ClientUtils.blockingWait(stage, timeout, unit);
        return Collectors.mapping(mapper, Collectors.toList());
    }

    public static <S extends CompletionStage<T>, T> Collector<S, ?, List<T>> blockingWaitForEachCollector(Duration duration) {
        return ClientUtils.blockingWaitForEachCollector(duration.toMillis(), TimeUnit.MILLISECONDS);
    }
}

