/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.vrap.rmf.base.client.ApiHttpClientImpl;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.ClientRequestCommand;
import io.vrap.rmf.base.client.ResponseSerializer;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.HandlerStack;
import java.net.URI;
import java.util.concurrent.CompletableFuture;

public interface ApiHttpClient
extends AutoCloseable,
VrapHttpClient {
    public static final String CLOSED_MESSAGE = "Client is already closed.";

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest var1, Class<O> var2);

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest var1, TypeReference<O> var2);

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ApiHttpRequest var1, JavaType var2);

    public <O> CompletableFuture<ApiHttpResponse<O>> execute(ClientRequestCommand<O> var1);

    public ResponseSerializer getSerializerService();

    public static ApiHttpClient of(String baseUri, HandlerStack stack) {
        return ApiHttpClient.of(URI.create(baseUri), stack, ResponseSerializer.of());
    }

    public static ApiHttpClient of(URI baseUri, HandlerStack stack) {
        return ApiHttpClient.of(baseUri, stack, ResponseSerializer.of());
    }

    public static ApiHttpClient of(String baseUri, HandlerStack stack, ResponseSerializer serializer) {
        return ApiHttpClient.of(URI.create(baseUri), stack, serializer);
    }

    public static ApiHttpClient of(URI baseUri, HandlerStack stack, ResponseSerializer serializer) {
        return new ApiHttpClientImpl(baseUri, stack, serializer);
    }
}

