/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import io.vrap.rmf.base.client.ApiHttpClient;
import io.vrap.rmf.base.client.ApiHttpHeaders;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.Base;
import io.vrap.rmf.base.client.ClientRequestCommand;
import io.vrap.rmf.base.client.EncodingException;
import io.vrap.rmf.base.client.RequestCommand;
import io.vrap.rmf.base.client.utils.ClientUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class ApiMethod<T extends ApiMethod<T, TResult>, TResult>
extends Base
implements RequestCommand<TResult>,
ClientRequestCommand<TResult> {
    private Function<ApiHttpRequest, ApiHttpRequest> httpRequestDecorator = Function.identity();
    private ApiHttpHeaders headers = new ApiHttpHeaders();
    private List<ParamEntry<String, String>> queryParams = new ArrayList<ParamEntry<String, String>>();
    private final ApiHttpClient apiHttpClient;

    protected ApiHttpClient apiHttpClient() {
        return this.apiHttpClient;
    }

    public ApiMethod(ApiHttpClient apiHttpClient) {
        this.apiHttpClient = apiHttpClient;
    }

    public ApiMethod(ApiHttpClient apiHttpClient, ApiHttpHeaders headers, List<ParamEntry<String, String>> queryParams) {
        this.apiHttpClient = apiHttpClient;
        this.headers = headers;
        this.queryParams = new ArrayList<ParamEntry<String, String>>(queryParams);
    }

    public ApiMethod(ApiMethod<T, TResult> apiMethod) {
        this.apiHttpClient = apiMethod.apiHttpClient;
        this.headers = new ApiHttpHeaders(apiMethod.headers);
        this.queryParams = new ArrayList<ParamEntry<String, String>>(apiMethod.queryParams);
    }

    public T addHeader(String key, String value) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.addHeader(key, value);
        return c;
    }

    public T withoutHeader(String key) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withoutHeader(key);
        return c;
    }

    public T withHeader(String key, String value) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withHeader(key, value);
        return c;
    }

    public T withHeaders(ApiHttpHeaders headers) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers = headers;
        return c;
    }

    public T contentType(String contentType) {
        T c = this.copy();
        ((ApiMethod)c).headers = ((ApiMethod)c).headers.withHeader("Content-Type", contentType);
        return c;
    }

    public ApiHttpHeaders getHeaders() {
        return this.headers;
    }

    public <V> T addQueryParam(String key, V value) {
        T c = this.copy();
        ((ApiMethod)c).queryParams.add(new ParamEntry<String, String>(key, value.toString()));
        return c;
    }

    public <V> T withQueryParam(String key, V value) {
        return ((ApiMethod)this.withoutQueryParam(key)).addQueryParam(key, value);
    }

    public T withoutQueryParam(String key) {
        T c = this.copy();
        ((ApiMethod)c).queryParams = ((ApiMethod)c).queryParams.stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase(key)).collect(Collectors.toList());
        return c;
    }

    public T withQueryParams(List<ParamEntry<String, String>> queryParams) {
        T c = this.copy();
        ((ApiMethod)c).queryParams = queryParams;
        return c;
    }

    public T addQueryParams(List<ParamEntry<String, String>> queryParams) {
        T c = this.copy();
        ((ApiMethod)c).queryParams.addAll(queryParams);
        return c;
    }

    public List<ParamEntry<String, String>> getQueryParams() {
        return new ArrayList<ParamEntry<String, String>>(this.queryParams);
    }

    public List<String> getQueryParam(String key) {
        return this.queryParams.stream().filter(e -> ((String)e.key).equals(key)).map(e -> (String)e.value).collect(Collectors.toList());
    }

    public List<String> getQueryParamUriStrings() {
        return this.queryParams.stream().map(ParamEntry::toUriString).collect(Collectors.toList());
    }

    public String getQueryParamUriString() {
        return this.queryParams.stream().map(ParamEntry::toUriString).collect(Collectors.joining("&"));
    }

    @Nullable
    public String getFirstQueryParam(String key) {
        return this.queryParams.stream().filter(e -> ((String)e.getKey()).equals(key)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    protected abstract T copy();

    protected abstract ApiHttpRequest buildHttpRequest();

    public ApiHttpRequest createHttpRequest() {
        return this.httpRequestDecorator.apply(this.buildHttpRequest());
    }

    @Override
    public CompletableFuture<ApiHttpResponse<TResult>> execute() {
        return this.execute(this.apiHttpClient());
    }

    @Override
    public abstract CompletableFuture<ApiHttpResponse<TResult>> execute(ApiHttpClient var1);

    public T withHttpRequest(Function<ApiHttpRequest, ApiHttpRequest> op) {
        T c = this.copy();
        ((ApiMethod)c).httpRequestDecorator = this.httpRequestDecorator.andThen(op);
        return c;
    }

    public T with(Function<T, T> op) {
        T c = this.copy();
        return (T)((ApiMethod)op.apply(c));
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(Class<TReturn> returnType) {
        return this.execute(this.apiHttpClient(), returnType);
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(ApiHttpClient client, Class<TReturn> returnType) {
        return client.execute(this.createHttpRequest(), returnType).toCompletableFuture();
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(TypeReference<TReturn> returnTypeReference) {
        return this.execute(this.apiHttpClient(), returnTypeReference);
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(ApiHttpClient client, TypeReference<TReturn> returnTypeReference) {
        return client.execute(this.createHttpRequest(), returnTypeReference).toCompletableFuture();
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(JavaType returnJavaType) {
        return this.execute(this.apiHttpClient(), returnJavaType);
    }

    public <TReturn> CompletableFuture<ApiHttpResponse<TReturn>> execute(ApiHttpClient client, JavaType returnJavaType) {
        return client.execute(this.createHttpRequest(), returnJavaType);
    }

    @Override
    public ApiHttpResponse<TResult> executeBlocking() {
        return this.executeBlocking(this.apiHttpClient(), Duration.ofSeconds(120L));
    }

    @Override
    public ApiHttpResponse<TResult> executeBlocking(ApiHttpClient client) {
        return this.executeBlocking(client, Duration.ofSeconds(120L));
    }

    @Override
    public ApiHttpResponse<TResult> executeBlocking(Duration timeout) {
        return this.executeBlocking(this.apiHttpClient(), timeout);
    }

    @Override
    public abstract ApiHttpResponse<TResult> executeBlocking(ApiHttpClient var1, Duration var2);

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Class<TReturn> clazz) {
        return this.executeBlocking(this.apiHttpClient(), Duration.ofSeconds(120L), clazz);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Class<TReturn> clazz) {
        return this.executeBlocking(client, Duration.ofSeconds(120L), clazz);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Duration timeout, Class<TReturn> clazz) {
        return this.executeBlocking(this.apiHttpClient(), timeout, clazz);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Duration timeout, Class<TReturn> clazz) {
        ApiHttpRequest request = this.createHttpRequest();
        return ClientUtils.blockingWait(client.execute(request, clazz).toCompletableFuture(), request, timeout);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(TypeReference<TReturn> typeReference) {
        return this.executeBlocking(this.apiHttpClient(), Duration.ofSeconds(120L), typeReference);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, TypeReference<TReturn> typeReference) {
        return this.executeBlocking(client, Duration.ofSeconds(120L), typeReference);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Duration timeout, TypeReference<TReturn> typeReference) {
        return this.executeBlocking(this.apiHttpClient(), timeout, typeReference);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Duration timeout, TypeReference<TReturn> typeReference) {
        ApiHttpRequest request = this.createHttpRequest();
        return ClientUtils.blockingWait(client.execute(request, typeReference).toCompletableFuture(), request, timeout);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(JavaType javaType) {
        return this.executeBlocking(this.apiHttpClient(), Duration.ofSeconds(120L), javaType);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, JavaType javaType) {
        return this.executeBlocking(client, Duration.ofSeconds(120L), javaType);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(Duration timeout, JavaType javaType) {
        return this.executeBlocking(this.apiHttpClient(), timeout, javaType);
    }

    public <TReturn> ApiHttpResponse<TReturn> executeBlocking(ApiHttpClient client, Duration timeout, JavaType javaType) {
        ApiHttpRequest request = this.createHttpRequest();
        return ClientUtils.blockingWait(client.execute(request, javaType), request, timeout);
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> send() {
        return this.apiHttpClient.execute(this.createHttpRequest());
    }

    public ApiHttpResponse<byte[]> sendBlocking() {
        return this.sendBlocking(Duration.ofSeconds(120L));
    }

    public ApiHttpResponse<byte[]> sendBlocking(Duration timeout) {
        return ClientUtils.blockingWait(this.send(), timeout);
    }

    public static class ParamEntry<K, V>
    extends Base
    implements Map.Entry<K, V> {
        protected final K key;
        protected V value;

        public ParamEntry(K key) {
            this.key = key;
        }

        public ParamEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toUriString() {
            try {
                return this.key + "=" + URLEncoder.encode(this.value.toString(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new EncodingException(e);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamEntry that = (ParamEntry)o;
            return new EqualsBuilder().append(this.key, that.key).append(this.value, that.value).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.key).append(this.value).toHashCode();
        }
    }
}

