/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AutoCloseableService;
import io.vrap.rmf.base.client.VrapHttpClient;
import io.vrap.rmf.base.client.http.HttpHandler;
import io.vrap.rmf.base.client.http.Middleware;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class HandlerStack
extends AutoCloseableService
implements VrapHttpClient {
    public String CLOSED_MESSAGE = "Handler is already closed.";
    private final HttpHandler handler;
    private final List<Middleware> middlewares;
    private Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> cached;

    private HandlerStack(HttpHandler handler, List<Middleware> middlewares) {
        this.handler = handler;
        this.middlewares = middlewares;
        this.cached = null;
    }

    public static HandlerStack create(HttpHandler handler, List<Middleware> middlewares) {
        return new HandlerStack(handler, middlewares);
    }

    public static HandlerStack create(HttpHandler handler) {
        return HandlerStack.create(handler, new ArrayList<Middleware>());
    }

    public void addMiddleware(Middleware middleware) {
        this.middlewares.add(middleware);
        this.cached = null;
    }

    public void addMiddlewares(List<Middleware> middlewares) {
        this.middlewares.addAll(middlewares);
        this.cached = null;
    }

    public void addMiddlewares(Middleware ... middlewares) {
        this.middlewares.addAll(Arrays.asList(middlewares));
        this.cached = null;
    }

    Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> resolve() {
        if (this.cached == null) {
            ArrayList<Middleware> stack = new ArrayList<Middleware>(this.middlewares);
            Function<ApiHttpRequest, CompletableFuture> prev = this.handler::execute;
            for (Middleware middleware : stack) {
                Function<ApiHttpRequest, CompletableFuture> finalPrev = prev;
                prev = request -> middleware.invoke((ApiHttpRequest)request, (Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>>)finalPrev);
            }
            this.cached = prev;
        }
        return this.cached;
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> execute(ApiHttpRequest request) {
        this.rejectExecutionIfClosed(this.CLOSED_MESSAGE);
        return this.invoke(request);
    }

    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request) {
        Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> handler = this.resolve();
        return handler.apply(request);
    }

    @Override
    protected void internalClose() {
        this.handler.close();
        this.middlewares.forEach(middleware -> {
            if (middleware instanceof AutoCloseable) {
                HandlerStack.closeQuietly((AutoCloseable)((Object)middleware));
            }
        });
    }
}

