/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import dev.failsafe.CircuitBreaker;
import dev.failsafe.CircuitBreakerBuilder;
import dev.failsafe.CircuitBreakerOpenException;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeExecutor;
import dev.failsafe.Fallback;
import dev.failsafe.FallbackBuilder;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.event.ExecutionAttemptedEvent;
import dev.failsafe.spi.Scheduler;
import io.vrap.rmf.base.client.ApiHttpRequest;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.AuthenticationToken;
import io.vrap.rmf.base.client.error.UnauthorizedException;
import io.vrap.rmf.base.client.http.InternalLogger;
import io.vrap.rmf.base.client.http.OAuthHandler;
import io.vrap.rmf.base.client.http.OAuthMiddleware;
import io.vrap.rmf.base.client.oauth2.AuthException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

public class OAuthMiddlewareImpl
implements AutoCloseable,
OAuthMiddleware {
    private final OAuthHandler authHandler;
    private static final InternalLogger logger = InternalLogger.getLogger("commercetools.auth");
    private final FailsafeExecutor<ApiHttpResponse<byte[]>> failsafeExecutor;

    public OAuthMiddlewareImpl(OAuthHandler oAuthHandler) {
        this(Scheduler.DEFAULT, oAuthHandler, 1, false);
    }

    public OAuthMiddlewareImpl(OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this(Scheduler.DEFAULT, oauthHandler, maxRetries, useCircuitBreaker);
    }

    public OAuthMiddlewareImpl(ScheduledExecutorService executorService, OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this(Scheduler.of((ScheduledExecutorService)executorService), oauthHandler, maxRetries, useCircuitBreaker);
    }

    public OAuthMiddlewareImpl(ExecutorService executor, OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this(Scheduler.of((ExecutorService)executor), oauthHandler, maxRetries, useCircuitBreaker);
    }

    public OAuthMiddlewareImpl(Scheduler scheduler, OAuthHandler oauthHandler, int maxRetries, boolean useCircuitBreaker) {
        this.authHandler = oauthHandler;
        RetryPolicy retry = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf((response, throwable) -> {
            if (throwable != null) {
                return throwable instanceof UnauthorizedException;
            }
            return response.getStatusCode() == 401;
        })).onRetry(event -> {
            logger.debug(() -> "Refresh Bearer token #" + event.getAttemptCount());
            this.authHandler.refreshToken();
        }).withMaxRetries(maxRetries).build();
        if (useCircuitBreaker) {
            Fallback fallback = ((FallbackBuilder)Fallback.builderOfException(event -> {
                logger.debug(() -> "Convert CircuitBreakerOpenException to AuthException");
                logger.trace(() -> ((ExecutionAttemptedEvent)event).getLastFailure());
                return new AuthException(400, "", null, "Authentication failed", null, event.getLastFailure());
            }).handleIf(throwable -> throwable instanceof CircuitBreakerOpenException)).build();
            CircuitBreaker circuitBreaker = ((CircuitBreakerBuilder)((CircuitBreakerBuilder)((CircuitBreakerBuilder)CircuitBreaker.builder().handleIf((response, throwable) -> {
                if (throwable.getCause() instanceof AuthException) {
                    return ((AuthException)throwable.getCause()).getResponse().getStatusCode() == 400;
                }
                return response.getStatusCode() == 400;
            })).withDelayFn(context -> Duration.ofMillis(Math.min(100 * context.getAttemptCount() * context.getAttemptCount(), 15000)))).withFailureThreshold(5, Duration.ofMinutes(1L)).withSuccessThreshold(2).onClose(event -> logger.debug(() -> "The authentication circuit breaker was closed")).onOpen(event -> logger.debug(() -> "The authentication circuit breaker was opened")).onHalfOpen(event -> logger.debug(() -> "The authentication circuit breaker was half-opened")).onFailure(event -> logger.trace(() -> "Authentication failed", event.getFailure()))).build();
            this.failsafeExecutor = Failsafe.with((Policy)fallback, (Policy[])new Policy[]{retry, circuitBreaker}).with(scheduler);
        } else {
            this.failsafeExecutor = Failsafe.with((Policy)retry, (Policy[])new RetryPolicy[0]).with(scheduler);
        }
    }

    @Override
    public CompletableFuture<ApiHttpResponse<byte[]>> invoke(ApiHttpRequest request, Function<ApiHttpRequest, CompletableFuture<ApiHttpResponse<byte[]>>> next) {
        return this.failsafeExecutor.getStageAsync(() -> {
            if (request.getHeaders().getFirst("Authorization") != null) {
                return (CompletionStage)next.apply(request);
            }
            AuthenticationToken token = this.authHandler.getToken();
            return (CompletionStage)next.apply(request.addHeader("Authorization", OAuthHandler.authHeader(token)));
        });
    }

    @Override
    public void close() {
        this.authHandler.close();
    }
}

