/*
 * Decompiled with CFR 0.152.
 */
package io.vrap.rmf.base.client.http;

import dev.failsafe.RetryPolicyBuilder;
import io.vrap.rmf.base.client.ApiHttpException;
import io.vrap.rmf.base.client.http.FailsafeRetryPolicyBuilderOptions;
import io.vrap.rmf.base.client.http.Middleware;
import io.vrap.rmf.base.client.http.RetryMiddleware;
import java.util.Arrays;
import java.util.List;

public interface RetryRequestMiddleware
extends Middleware {
    public static final int DEFAULT_MAX_DELAY = 60000;
    public static final int DEFAULT_INITIAL_DELAY = 200;
    public static final List<Integer> DEFAULT_RETRY_STATUS_CODES = Arrays.asList(500, 503);

    public static RetryRequestMiddleware of(int maxRetries) {
        return new RetryMiddleware(maxRetries, 200L, 60000L, DEFAULT_RETRY_STATUS_CODES, null);
    }

    public static RetryRequestMiddleware of(int maxRetries, List<Integer> statusCodes) {
        return new RetryMiddleware(maxRetries, 200L, 60000L, statusCodes, null);
    }

    public static RetryRequestMiddleware of(int maxRetries, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        return new RetryMiddleware(maxRetries, 200L, 60000L, statusCodes, failures);
    }

    public static RetryRequestMiddleware of(int maxRetries, long delay, long maxDelay) {
        return new RetryMiddleware(maxRetries, delay, maxDelay, DEFAULT_RETRY_STATUS_CODES, null);
    }

    public static RetryRequestMiddleware of(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes) {
        return new RetryMiddleware(maxRetries, delay, maxDelay, statusCodes, null);
    }

    public static RetryRequestMiddleware of(int maxRetries, long delay, long maxDelay, List<Integer> statusCodes, List<Class<? extends Throwable>> failures) {
        return new RetryMiddleware(maxRetries, delay, maxDelay, RetryRequestMiddleware.handleFailures(failures).andThen(RetryRequestMiddleware.handleStatusCodes(statusCodes)));
    }

    public static RetryRequestMiddleware of(int maxRetries, long delay, long maxDelay, FailsafeRetryPolicyBuilderOptions fn) {
        return new RetryMiddleware(maxRetries, delay, maxDelay, fn);
    }

    public static FailsafeRetryPolicyBuilderOptions handleFailures(List<Class<? extends Throwable>> failures) {
        return builder -> {
            if (failures != null) {
                builder.handle(failures);
            }
            return builder;
        };
    }

    public static FailsafeRetryPolicyBuilderOptions handleStatusCodes(List<Integer> statusCodes) {
        return builder -> (RetryPolicyBuilder)builder.handleIf((response, throwable) -> {
            if (throwable instanceof ApiHttpException) {
                return statusCodes.contains(((ApiHttpException)throwable).getStatusCode());
            }
            return statusCodes.contains(response.getStatusCode());
        });
    }
}

