/*
 * Decompiled with CFR 0.152.
 */
package io.sphere.json;

import cats.Applicative;
import cats.Invariant;
import cats.Semigroupal;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.syntax.package;
import io.sphere.json.FromJSON;
import io.sphere.json.FromJSON$;
import io.sphere.json.FromJSON$mcD$sp;
import io.sphere.json.FromJSON$mcF$sp;
import io.sphere.json.FromJSON$mcI$sp;
import io.sphere.json.FromJSON$mcJ$sp;
import io.sphere.json.FromJSON$mcS$sp;
import io.sphere.json.FromJSON$mcV$sp;
import io.sphere.json.FromJSON$mcZ$sp;
import io.sphere.json.JSONError;
import io.sphere.json.JSONParseError$;
import io.sphere.json.package$;
import io.sphere.util.BaseMoney;
import io.sphere.util.BaseMoney$;
import io.sphere.util.HighPrecisionMoney;
import io.sphere.util.HighPrecisionMoney$;
import io.sphere.util.LangTag;
import io.sphere.util.LangTag$;
import io.sphere.util.Money;
import io.sphere.util.Money$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Currency;
import java.util.Locale;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.YearMonth;
import org.joda.time.format.ISODateTimeFormat;
import org.json4s.JsonAST;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.ListBuffer;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

public final class FromJSON$
implements Serializable {
    public static final FromJSON$ MODULE$ = new FromJSON$();
    private static final Set<String> emptyFieldsSet = Predef$.MODULE$.Set().empty();
    private static final Validated.Valid<None$> io$sphere$json$FromJSON$$validNone = new Validated.Valid((Object)None$.MODULE$);
    private static final FromJSON<Object> intReader = new FromJSON$mcI$sp(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, Object> read(JsonAST.JValue jval) {
            JsonAST.JLong jLong;
            long i;
            JsonAST.JInt jInt;
            BigInt i2;
            JsonAST.JValue jValue = jval;
            Validated.Valid valid = jValue instanceof JsonAST.JInt && (i2 = (jInt = (JsonAST.JInt)jValue).num()).isValidInt() ? new Validated.Valid((Object)BoxesRunTime.boxToInteger((int)i2.toInt())) : (jValue instanceof JsonAST.JLong && RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(i = (jLong = (JsonAST.JLong)jValue).num())) ? new Validated.Valid((Object)BoxesRunTime.boxToInteger((int)((int)i))) : this.fail("JSON Number in the range of an Int expected."));
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<String> stringReader = new FromJSON<String>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, String> read(JsonAST.JValue jval) {
            Validated.Valid valid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JString) {
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                valid = new Validated.Valid((Object)s);
            } else {
                valid = this.fail("JSON String expected.");
            }
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<BigInt> bigIntReader = new FromJSON<BigInt>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, BigInt> read(JsonAST.JValue jval) {
            Validated.Valid valid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt i = jInt.num();
                valid = new Validated.Valid((Object)i);
            } else if (jValue instanceof JsonAST.JLong) {
                JsonAST.JLong jLong = (JsonAST.JLong)jValue;
                long l = jLong.num();
                valid = new Validated.Valid((Object)BigInt$.MODULE$.long2bigInt(l));
            } else {
                valid = this.fail("JSON Number in the range of a BigInt expected.");
            }
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<Object> shortReader = new FromJSON$mcS$sp(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, Object> read(JsonAST.JValue jval) {
            JsonAST.JLong jLong;
            long l;
            JsonAST.JInt jInt;
            BigInt i;
            JsonAST.JValue jValue = jval;
            Validated.Valid valid = jValue instanceof JsonAST.JInt && (i = (jInt = (JsonAST.JInt)jValue).num()).isValidShort() ? new Validated.Valid((Object)BoxesRunTime.boxToShort((short)i.toShort())) : (jValue instanceof JsonAST.JLong && RichLong$.MODULE$.isValidShort$extension(Predef$.MODULE$.longWrapper(l = (jLong = (JsonAST.JLong)jValue).num())) ? new Validated.Valid((Object)BoxesRunTime.boxToShort((short)((short)l))) : this.fail("JSON Number in the range of a Short expected."));
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<Object> longReader = new FromJSON$mcJ$sp(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, Object> read(JsonAST.JValue jval) {
            Validated.Valid valid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt i = jInt.num();
                valid = new Validated.Valid((Object)BoxesRunTime.boxToLong((long)i.toLong()));
            } else if (jValue instanceof JsonAST.JLong) {
                JsonAST.JLong jLong = (JsonAST.JLong)jValue;
                long l = jLong.num();
                valid = new Validated.Valid((Object)BoxesRunTime.boxToLong((long)l));
            } else {
                valid = this.fail("JSON Number in the range of a Long expected.");
            }
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<Object> floatReader = new FromJSON$mcF$sp(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, Object> read(JsonAST.JValue jval) {
            Validated.Valid valid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double d = jDouble.num();
                valid = new Validated.Valid((Object)BoxesRunTime.boxToFloat((float)((float)d)));
            } else {
                valid = this.fail("JSON Number in the range of a Float expected.");
            }
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<Object> doubleReader = new FromJSON$mcD$sp(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, Object> read(JsonAST.JValue jval) {
            Validated.Valid valid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JDouble) {
                JsonAST.JDouble jDouble = (JsonAST.JDouble)jValue;
                double d = jDouble.num();
                valid = new Validated.Valid((Object)BoxesRunTime.boxToDouble((double)d));
            } else if (jValue instanceof JsonAST.JInt) {
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt i = jInt.num();
                valid = new Validated.Valid((Object)BoxesRunTime.boxToDouble((double)i.toDouble()));
            } else if (jValue instanceof JsonAST.JLong) {
                JsonAST.JLong jLong = (JsonAST.JLong)jValue;
                long l = jLong.num();
                valid = new Validated.Valid((Object)BoxesRunTime.boxToDouble((double)l));
            } else {
                valid = this.fail("JSON Number in the range of a Double expected.");
            }
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<Object> booleanReader = new FromJSON$mcZ$sp(){
        private final Validated.Valid<Object> cachedTrue;
        private final Validated.Valid<Object> cachedFalse;
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        private Validated.Valid<Object> cachedTrue() {
            return this.cachedTrue;
        }

        private Validated.Valid<Object> cachedFalse() {
            return this.cachedFalse;
        }

        public Validated<NonEmptyList<JSONError>, Object> read(JsonAST.JValue jval) {
            JsonAST.JBool jBool;
            boolean b;
            JsonAST.JValue jValue = jval;
            Object object = jValue instanceof JsonAST.JBool ? ((b = (jBool = (JsonAST.JBool)jValue).value()) ? this.cachedTrue() : this.cachedFalse()) : this.fail("JSON Boolean expected");
            return object;
        }
        {
            FromJSON.$init$(this);
            this.cachedTrue = new Validated.Valid((Object)BoxesRunTime.boxToBoolean((boolean)true));
            this.cachedFalse = new Validated.Valid((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Statics.releaseFence();
        }
    };
    private static final FromJSON<Money> moneyReader = new FromJSON<Money>(){
        private final Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
        }

        public Set<String> fields() {
            return this.fields;
        }

        /*
         * Unable to fully structure code
         */
        public Validated<NonEmptyList<JSONError>, Money> read(JsonAST.JValue value) {
            block9: {
                block6: {
                    block8: {
                        block7: {
                            var4_2 = value;
                            if (!(var4_2 instanceof JsonAST.JObject)) break block6;
                            var5_3 = (JsonAST.JObject)var4_2;
                            var6_4 = new Tuple2(package$.MODULE$.field(Money$.MODULE$.CentAmountField(), package$.MODULE$.field$default$2(), var5_3, FromJSON$.MODULE$.longReader()), package$.MODULE$.field(Money$.MODULE$.CurrencyCodeField(), package$.MODULE$.field$default$2(), var5_3, FromJSON$.MODULE$.currencyReader()));
                            if (var6_4 == null) break block7;
                            var7_5 = (Validated)var6_4._1();
                            var8_6 = (Validated)var6_4._2();
                            if (!(var7_5 instanceof Validated.Valid)) break block7;
                            var9_7 = (Validated.Valid)var7_5;
                            centAmount = BoxesRunTime.unboxToLong((Object)var9_7.a());
                            if (!(var8_6 instanceof Validated.Valid)) break block7;
                            var12_9 = (Validated.Valid)var8_6;
                            currencyCode = (Currency)var12_9.a();
                            var3_11 = new Validated.Valid((Object)Money$.MODULE$.fromCentAmount(centAmount, currencyCode));
                            break block8;
                        }
                        if (var6_4 == null) ** GOTO lbl-1000
                        var14_12 = (Validated)var6_4._1();
                        var15_13 = (Validated)var6_4._2();
                        if (!(var14_12 instanceof Validated.Invalid)) ** GOTO lbl-1000
                        var16_14 = (Validated.Invalid)var14_12;
                        e1 = (NonEmptyList)var16_14.e();
                        if (var15_13 instanceof Validated.Invalid) {
                            var18_16 = (Validated.Invalid)var15_13;
                            e2 = (NonEmptyList)var18_16.e();
                            var3_11 = new Validated.Invalid((Object)e1.concat(e2.toList()));
                        } else if (var6_4 != null && (e1 = (Validated)var6_4._1()) instanceof Validated.Invalid) {
                            var3_11 = var21_19 = (Validated.Invalid)e1;
                        } else if (var6_4 != null && (e2 = (Validated)var6_4._2()) instanceof Validated.Invalid) {
                            var3_11 = var23_21 = (Validated.Invalid)e2;
                        } else {
                            throw new MatchError((Object)var6_4);
                        }
                    }
                    var2_22 = var3_11;
                    break block9;
                }
                var2_22 = this.fail("JSON object expected.");
            }
            return var2_22;
        }
        {
            FromJSON.$init$(this);
            this.fields = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{Money$.MODULE$.CentAmountField(), Money$.MODULE$.CurrencyCodeField()}));
        }
    };
    private static final FromJSON<HighPrecisionMoney> highPrecisionMoneyReader = new FromJSON<HighPrecisionMoney>(){
        private final Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
        }

        public Set<String> fields() {
            return this.fields;
        }

        public Validated<NonEmptyList<JSONError>, HighPrecisionMoney> read(JsonAST.JValue value) {
            Validated validated;
            JsonAST.JValue jValue = value;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                Tuple4 validatedFields = new Tuple4(package$.MODULE$.field(HighPrecisionMoney$.MODULE$.PreciseAmountField(), package$.MODULE$.field$default$2(), jObject, FromJSON$.MODULE$.longReader()), package$.MODULE$.field(HighPrecisionMoney$.MODULE$.FractionDigitsField(), package$.MODULE$.field$default$2(), jObject, FromJSON$.MODULE$.intReader()), package$.MODULE$.field(HighPrecisionMoney$.MODULE$.CurrencyCodeField(), package$.MODULE$.field$default$2(), jObject, FromJSON$.MODULE$.currencyReader()), package$.MODULE$.field(HighPrecisionMoney$.MODULE$.CentAmountField(), package$.MODULE$.field$default$2(), jObject, FromJSON$.MODULE$.optionReader$mJc$sp(FromJSON$.MODULE$.longReader())));
                validated = ((Validated)package.apply$.MODULE$.catsSyntaxTuple4Semigroupal(validatedFields).tupled((Invariant)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).andThen((Function1 & Serializable)x0$1 -> {
                    Tuple4 tuple4 = x0$1;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    long preciseAmount = BoxesRunTime.unboxToLong((Object)tuple4._1());
                    int fractionDigits = BoxesRunTime.unboxToInt((Object)tuple4._2());
                    Currency currencyCode = (Currency)tuple4._3();
                    Option centAmount = (Option)tuple4._4();
                    Validated validated = HighPrecisionMoney$.MODULE$.fromPreciseAmount(preciseAmount, fractionDigits, currencyCode, centAmount).leftMap((Function1 & Serializable)x$3 -> x$3.map((Function1)JSONParseError$.MODULE$));
                    return validated;
                });
            } else {
                validated = this.fail("JSON object expected.");
            }
            return validated;
        }
        {
            FromJSON.$init$(this);
            this.fields = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{HighPrecisionMoney$.MODULE$.PreciseAmountField(), HighPrecisionMoney$.MODULE$.CurrencyCodeField(), HighPrecisionMoney$.MODULE$.FractionDigitsField()}));
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$10(scala.Tuple4 ), $anonfun$read$11(cats.data.NonEmptyList )}, serializedLambda);
        }
    };
    private static final FromJSON<BaseMoney> baseMoneyReader = new FromJSON<BaseMoney>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, BaseMoney> read(JsonAST.JValue value) {
            Validated validated;
            JsonAST.JValue jValue = value;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                validated = package$.MODULE$.field(BaseMoney$.MODULE$.TypeField(), package$.MODULE$.field$default$2(), jObject, FromJSON$.MODULE$.optionReader(FromJSON$.MODULE$.stringReader())).andThen((Function1 & Serializable)x0$1 -> {
                    boolean bl = false;
                    Some some = null;
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        return FromJSON$.MODULE$.moneyReader().read(value);
                    }
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        String string = (String)some.value();
                        String string2 = Money$.MODULE$.TypeName();
                        String string3 = string;
                        if (string2 == null) {
                            if (string3 == null) return FromJSON$.MODULE$.moneyReader().read(value);
                        } else if (string2.equals(string3)) {
                            return FromJSON$.MODULE$.moneyReader().read(value);
                        }
                    }
                    if (bl) {
                        String string = (String)some.value();
                        String string4 = HighPrecisionMoney$.MODULE$.TypeName();
                        String string5 = string;
                        if (string4 == null) {
                            if (string5 == null) return FromJSON$.MODULE$.highPrecisionMoneyReader().read(value);
                        } else if (string4.equals(string5)) {
                            return FromJSON$.MODULE$.highPrecisionMoneyReader().read(value);
                        }
                    }
                    if (!bl) throw new MatchError((Object)option);
                    String tpe = (String)some.value();
                    return this.fail(new StringBuilder(51).append("Unknown money type '").append(tpe).append("'. Available types are: '").append(Money$.MODULE$.TypeName()).append("', '").append(HighPrecisionMoney$.MODULE$.TypeName()).append("'.").toString());
                });
            } else {
                validated = this.fail("JSON object expected.");
            }
            return validated;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }

        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$12(io.sphere.json.FromJSON$$anon$18 org.json4s.JsonAST$JValue scala.Option )}, serializedLambda);
        }
    };
    private static final FromJSON<Currency> currencyReader = new FromJSON<Currency>(){
        private final String failMsg;
        private final Validated.Valid<Currency> cachedEUR;
        private final Validated.Valid<Currency> cachedUSD;
        private final Validated.Valid<Currency> cachedGBP;
        private final Validated.Valid<Currency> cachedJPY;
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        private String failMsg() {
            return this.failMsg;
        }

        private String failMsgFor(String input) {
            return new StringBuilder(39).append("Currency '").append(input).append("' not valid as ISO 4217 code.").toString();
        }

        private Validated.Valid<Currency> cachedEUR() {
            return this.cachedEUR;
        }

        private Validated.Valid<Currency> cachedUSD() {
            return this.cachedUSD;
        }

        private Validated.Valid<Currency> cachedGBP() {
            return this.cachedGBP;
        }

        private Validated.Valid<Currency> cachedJPY() {
            return this.cachedJPY;
        }

        public Validated<NonEmptyList<JSONError>, Currency> read(JsonAST.JValue jval) {
            Validated.Invalid<NonEmptyList<JSONError>> invalid;
            block15: {
                block9: {
                    Validated.Invalid<NonEmptyList<JSONError>> invalid2;
                    block14: {
                        Validated.Invalid<NonEmptyList<JSONError>> invalid3;
                        String s;
                        block10: {
                            block12: {
                                block11: {
                                    block13: {
                                        JsonAST.JValue jValue = jval;
                                        if (!(jValue instanceof JsonAST.JString)) break block9;
                                        JsonAST.JString jString = (JsonAST.JString)jValue;
                                        s = jString.s();
                                        String string = s;
                                        switch (string == null ? 0 : string.hashCode()) {
                                            case 69026: {
                                                if ("EUR".equals(string)) {
                                                    break;
                                                }
                                                break block10;
                                            }
                                            case 70357: {
                                                if (!"GBP".equals(string)) break block10;
                                                break block11;
                                            }
                                            case 73683: {
                                                if (!"JPY".equals(string)) break block10;
                                                break block12;
                                            }
                                            case 84326: {
                                                if (!"USD".equals(string)) break block10;
                                                break block13;
                                            }
                                            default: {
                                                break block10;
                                            }
                                        }
                                        invalid2 = this.cachedEUR();
                                        break block14;
                                    }
                                    invalid2 = this.cachedUSD();
                                    break block14;
                                }
                                invalid2 = this.cachedGBP();
                                break block14;
                            }
                            invalid2 = this.cachedJPY();
                            break block14;
                        }
                        try {
                            invalid3 = new Validated.Invalid<NonEmptyList<JSONError>>((Object)Currency.getInstance(s));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            invalid3 = this.fail(this.failMsgFor(s));
                        }
                        invalid2 = invalid3;
                    }
                    invalid = invalid2;
                    break block15;
                }
                invalid = this.fail(this.failMsg());
            }
            return invalid;
        }
        {
            FromJSON.$init$(this);
            this.failMsg = "ISO 4217 code JSON String expected.";
            this.cachedEUR = new Validated.Valid((Object)Currency.getInstance("EUR"));
            this.cachedUSD = new Validated.Valid((Object)Currency.getInstance("USD"));
            this.cachedGBP = new Validated.Valid((Object)Currency.getInstance("GBP"));
            this.cachedJPY = new Validated.Valid((Object)Currency.getInstance("JPY"));
            Statics.releaseFence();
        }
    };
    private static final FromJSON<JsonAST.JValue> jValueReader = new FromJSON<JsonAST.JValue>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, JsonAST.JValue> read(JsonAST.JValue jval) {
            return new Validated.Valid((Object)jval);
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<JsonAST.JObject> jObjectReader = new FromJSON<JsonAST.JObject>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, JsonAST.JObject> read(JsonAST.JValue jval) {
            Validated.Valid valid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                valid = new Validated.Valid((Object)jObject);
            } else {
                valid = this.fail("JSON object expected");
            }
            return valid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final Validated.Valid<BoxedUnit> io$sphere$json$FromJSON$$validUnit = new Validated.Valid((Object)BoxedUnit.UNIT);
    private static final FromJSON<BoxedUnit> unitReader = new FromJSON$mcV$sp(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public Validated<NonEmptyList<JSONError>, BoxedUnit> read(JsonAST.JValue jval) {
            block3: {
                block4: {
                    block2: {
                        var4_2 = jval;
                        if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block2;
                        var3_3 = true;
                        break block3;
                    }
                    if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block4;
                    var3_3 = true;
                    break block3;
                }
                if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                var5_4 = (JsonAST.JObject)var4_2;
                var6_5 = var5_4.obj();
                v0 = scala.package$.MODULE$.Nil();
                var7_6 = var6_5;
                if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                    var3_3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var3_3 = false;
                }
            }
            var2_7 /* !! */  = var3_3 ? FromJSON$.MODULE$.io$sphere$json$FromJSON$$validUnit() : this.fail("Unexpected JSON");
            return var2_7 /* !! */ ;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<DateTime> dateTimeReader = new FromJSON<DateTime>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, DateTime> read(JsonAST.JValue jval) {
            Validated.Invalid<NonEmptyList<JSONError>> invalid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JString) {
                Validated.Invalid<NonEmptyList<JSONError>> invalid2;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                try {
                    invalid2 = new Validated.Invalid<NonEmptyList<JSONError>>((Object)new DateTime((Object)s, DateTimeZone.UTC));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Validated.Invalid<NonEmptyList<JSONError>> invalid3 = this.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to parse date/time: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                    invalid2 = invalid3;
                }
                invalid = invalid2;
            } else {
                invalid = this.fail("JSON string expected.");
            }
            return invalid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<LocalTime> timeReader = new FromJSON<LocalTime>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, LocalTime> read(JsonAST.JValue jval) {
            Validated.Invalid<NonEmptyList<JSONError>> invalid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JString) {
                Validated.Invalid<NonEmptyList<JSONError>> invalid2;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                try {
                    invalid2 = new Validated.Invalid<NonEmptyList<JSONError>>((Object)ISODateTimeFormat.localTimeParser().parseDateTime(s).toLocalTime());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Validated.Invalid<NonEmptyList<JSONError>> invalid3 = this.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to parse time: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                    invalid2 = invalid3;
                }
                invalid = invalid2;
            } else {
                invalid = this.fail("JSON string expected.");
            }
            return invalid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<LocalDate> dateReader = new FromJSON<LocalDate>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, LocalDate> read(JsonAST.JValue jval) {
            Validated.Invalid<NonEmptyList<JSONError>> invalid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JString) {
                Validated.Invalid<NonEmptyList<JSONError>> invalid2;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                try {
                    invalid2 = new Validated.Invalid<NonEmptyList<JSONError>>((Object)ISODateTimeFormat.localDateParser().parseDateTime(s).toLocalDate());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Validated.Invalid<NonEmptyList<JSONError>> invalid3 = this.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to parse date: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                    invalid2 = invalid3;
                }
                invalid = invalid2;
            } else {
                invalid = this.fail("JSON string expected.");
            }
            return invalid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<YearMonth> yearMonthReader = new FromJSON<YearMonth>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, YearMonth> read(JsonAST.JValue jval) {
            Validated.Invalid<NonEmptyList<JSONError>> invalid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JString) {
                Validated.Invalid<NonEmptyList<JSONError>> invalid2;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                try {
                    invalid2 = new Validated.Invalid<NonEmptyList<JSONError>>((Object)new YearMonth((Object)s));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Validated.Invalid<NonEmptyList<JSONError>> invalid3 = this.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Failed to parse year/month: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                    invalid2 = invalid3;
                }
                invalid = invalid2;
            } else {
                invalid = this.fail("JSON Object expected.");
            }
            return invalid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<UUID> uuidReader = new FromJSON<UUID>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, UUID> read(JsonAST.JValue jval) {
            Validated.Invalid<NonEmptyList<JSONError>> invalid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JString) {
                Validated.Invalid<NonEmptyList<JSONError>> invalid2;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                try {
                    invalid2 = new Validated.Invalid<NonEmptyList<JSONError>>((Object)UUID.fromString(s));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Validated.Invalid<NonEmptyList<JSONError>> invalid3 = this.fail(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Invalid UUID: '%s'"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s})));
                    invalid2 = invalid3;
                }
                invalid = invalid2;
            } else {
                invalid = this.fail("JSON string expected.");
            }
            return invalid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };
    private static final FromJSON<Locale> localeReader = new FromJSON<Locale>(){
        private Set<String> fields;

        public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
            return FromJSON.fail$(this, msg);
        }

        public Set<String> fields() {
            return this.fields;
        }

        public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            this.fields = x$1;
        }

        public Validated<NonEmptyList<JSONError>, Locale> read(JsonAST.JValue jval) {
            Validated.Invalid<NonEmptyList<JSONError>> invalid;
            JsonAST.JValue jValue = jval;
            if (jValue instanceof JsonAST.JString) {
                Validated.Valid valid;
                Locale locale;
                JsonAST.JString jString = (JsonAST.JString)jValue;
                String s = jString.s();
                String string = s;
                if (string != null && !LangTag.LocaleOpt$.MODULE$.isEmpty$extension(locale = LangTag$.MODULE$.unapply(string))) {
                    Locale langTag = LangTag.LocaleOpt$.MODULE$.get$extension(locale);
                    valid = new Validated.Valid((Object)langTag);
                } else {
                    valid = this.fail(LangTag$.MODULE$.invalidLangTagMessage(s));
                }
                invalid = valid;
            } else {
                invalid = this.fail("JSON string expected.");
            }
            return invalid;
        }
        {
            FromJSON.$init$(this);
            Statics.releaseFence();
        }
    };

    public Set<String> emptyFieldsSet() {
        return emptyFieldsSet;
    }

    public <A> FromJSON<A> apply(FromJSON<A> instance) {
        return instance;
    }

    public Validated.Valid<None$> io$sphere$json$FromJSON$$validNone() {
        return io$sphere$json$FromJSON$$validNone;
    }

    public <A> FromJSON<Option<A>> optionReader(FromJSON<A> c) {
        return new FromJSON<Option<A>>(c){
            private final Set<String> fields;
            private final FromJSON c$1;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<A>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$1$adapted(io.sphere.json.FromJSON$$anon$1 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$1.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$2(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$1(anon.1 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$2(Object x) {
                return Option$.MODULE$.apply(x);
            }
            {
                this.c$1 = c$1;
                FromJSON.$init$(this);
                this.fields = c$1.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$1$adapted(anon.1 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$read$1($this, t));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$1$adapted(io.sphere.json.FromJSON$$anon$1 scala.Tuple2 ), $anonfun$read$2(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <A> FromJSON<List<A>> listReader(FromJSON<A> r) {
        return new FromJSON<List<A>>(r){
            private Set<String> fields;
            private final FromJSON r$1;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<A>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$1.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            Object s = valid.a();
                            if (!failedOnce$1.elem) {
                                return valids.$plus$eq(s);
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$1.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$1 = r$1;
                FromJSON.$init$(this);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$3(io.sphere.json.FromJSON$$anon$2 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public <A> FromJSON<Seq<A>> seqReader(FromJSON<A> r) {
        return new FromJSON<Seq<A>>(r){
            private Set<String> fields;
            private final FromJSON r$2;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<A>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader(this.r$2).read(jval);
            }
            {
                this.r$2 = r$2;
                FromJSON.$init$(this);
                Statics.releaseFence();
            }
        };
    }

    public <A> FromJSON<Set<A>> setReader(FromJSON<A> r) {
        return new FromJSON<Set<A>>(r){
            private Set<String> fields;
            private final FromJSON r$3;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<A>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader(this.r$3).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$3 = r$3;
                FromJSON.$init$(this);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$4(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public <A> FromJSON<Vector<A>> vectorReader(FromJSON<A> r) {
        return new FromJSON<Vector<A>>(r){
            private Set<String> fields;
            private final FromJSON r$4;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<A>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$4.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            Object s = valid.a();
                            if (!failedOnce$2.elem) {
                                return valids.$plus$eq(s);
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$2.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$4 = r$4;
                FromJSON.$init$(this);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$5(io.sphere.json.FromJSON$$anon$5 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public <A> FromJSON<NonEmptyList<A>> nonEmptyListReader(FromJSON<A> r) {
        return new FromJSON<NonEmptyList<A>>(r){
            private Set<String> fields;
            private final FromJSON r$5;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, NonEmptyList<A>> read(JsonAST.JValue jval) {
                return package$.MODULE$.fromJValue(jval, FromJSON$.MODULE$.listReader(this.r$5)).andThen((Function1 & Serializable)x0$1 -> {
                    Validated.Valid valid;
                    List list = x0$1;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon2 = (.colon.colon)list;
                        Object head = colon2.head();
                        List tail = colon2.next$access$1();
                        valid = new Validated.Valid((Object)new NonEmptyList(head, tail));
                    } else {
                        Nil$ nil$ = scala.package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                            valid = this.fail("Non-empty JSON array expected");
                        } else {
                            throw new MatchError((Object)list);
                        }
                    }
                    return valid;
                });
            }
            {
                this.r$5 = r$5;
                FromJSON.$init$(this);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$6(io.sphere.json.FromJSON$$anon$6 scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Object> intReader() {
        return intReader;
    }

    public FromJSON<String> stringReader() {
        return stringReader;
    }

    public FromJSON<BigInt> bigIntReader() {
        return bigIntReader;
    }

    public FromJSON<Object> shortReader() {
        return shortReader;
    }

    public FromJSON<Object> longReader() {
        return longReader;
    }

    public FromJSON<Object> floatReader() {
        return floatReader;
    }

    public FromJSON<Object> doubleReader() {
        return doubleReader;
    }

    public FromJSON<Object> booleanReader() {
        return booleanReader;
    }

    public <A> FromJSON<Map<String, A>> mapReader(FromJSON<A> evidence$1) {
        return new FromJSON<Map<String, A>>(evidence$1){
            private Set<String> fields;
            private final FromJSON evidence$1$1;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Map<String, A>> read(JsonAST.JValue json) {
                Validated validated;
                JsonAST.JValue jValue = json;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List fs = jObject.obj();
                    validated = ((Validated)package.traverse$.MODULE$.toTraverseOps((Object)fs, UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)f -> package$.MODULE$.fromJValue((JsonAST.JValue)f._2(), $this.evidence$1$1).map((Function1 & Serializable)v -> new Tuple2(f._1(), v)), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).map((Function1 & Serializable)x$2 -> x$2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                } else {
                    validated = this.fail("JSON Object expected");
                }
                return validated;
            }
            {
                this.evidence$1$1 = evidence$1$1;
                FromJSON.$init$(this);
                Statics.releaseFence();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$7(io.sphere.json.FromJSON$$anon$15 scala.Tuple2 ), $anonfun$read$8(scala.Tuple2 java.lang.Object ), $anonfun$read$9(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Money> moneyReader() {
        return moneyReader;
    }

    public FromJSON<HighPrecisionMoney> highPrecisionMoneyReader() {
        return highPrecisionMoneyReader;
    }

    public FromJSON<BaseMoney> baseMoneyReader() {
        return baseMoneyReader;
    }

    public FromJSON<Currency> currencyReader() {
        return currencyReader;
    }

    public FromJSON<JsonAST.JValue> jValueReader() {
        return jValueReader;
    }

    public FromJSON<JsonAST.JObject> jObjectReader() {
        return jObjectReader;
    }

    public Validated.Valid<BoxedUnit> io$sphere$json$FromJSON$$validUnit() {
        return io$sphere$json$FromJSON$$validUnit;
    }

    public FromJSON<BoxedUnit> unitReader() {
        return unitReader;
    }

    public FromJSON<DateTime> dateTimeReader() {
        return dateTimeReader;
    }

    public FromJSON<LocalTime> timeReader() {
        return timeReader;
    }

    public FromJSON<LocalDate> dateReader() {
        return dateReader;
    }

    public FromJSON<YearMonth> yearMonthReader() {
        return yearMonthReader;
    }

    public FromJSON<UUID> uuidReader() {
        return uuidReader;
    }

    public FromJSON<Locale> localeReader() {
        return localeReader;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FromJSON$.class);
    }

    public FromJSON<Option<Object>> optionReader$mZc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$2;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$13$adapted(io.sphere.json.FromJSON$$anon$29 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$2.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$14$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$13(anon.29 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$14(boolean x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)x));
            }
            {
                this.c$2 = c$2;
                FromJSON.$init$(this);
                this.fields = c$2.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$13$adapted(anon.29 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.29.$anonfun$read$13($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$14$adapted(Object x) {
                return anon.29.$anonfun$read$14(BoxesRunTime.unboxToBoolean((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$13$adapted(io.sphere.json.FromJSON$$anon$29 scala.Tuple2 ), $anonfun$read$14$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<Object>> optionReader$mBc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$3;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$15$adapted(io.sphere.json.FromJSON$$anon$30 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$3.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$16$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$15(anon.30 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$16(byte x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)x));
            }
            {
                this.c$3 = c$3;
                FromJSON.$init$(this);
                this.fields = c$3.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$15$adapted(anon.30 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.30.$anonfun$read$15($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$16$adapted(Object x) {
                return anon.30.$anonfun$read$16(BoxesRunTime.unboxToByte((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$15$adapted(io.sphere.json.FromJSON$$anon$30 scala.Tuple2 ), $anonfun$read$16$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<Object>> optionReader$mCc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$4;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$17$adapted(io.sphere.json.FromJSON$$anon$31 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$4.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$18$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$17(anon.31 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$18(char x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)x));
            }
            {
                this.c$4 = c$4;
                FromJSON.$init$(this);
                this.fields = c$4.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$17$adapted(anon.31 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.31.$anonfun$read$17($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$18$adapted(Object x) {
                return anon.31.$anonfun$read$18(BoxesRunTime.unboxToChar((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$17$adapted(io.sphere.json.FromJSON$$anon$31 scala.Tuple2 ), $anonfun$read$18$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<Object>> optionReader$mDc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$5;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$19$adapted(io.sphere.json.FromJSON$$anon$32 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$5.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$20$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$19(anon.32 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$20(double x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x));
            }
            {
                this.c$5 = c$5;
                FromJSON.$init$(this);
                this.fields = c$5.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$19$adapted(anon.32 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.32.$anonfun$read$19($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$20$adapted(Object x) {
                return anon.32.$anonfun$read$20(BoxesRunTime.unboxToDouble((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$19$adapted(io.sphere.json.FromJSON$$anon$32 scala.Tuple2 ), $anonfun$read$20$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<Object>> optionReader$mFc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$6;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$21$adapted(io.sphere.json.FromJSON$$anon$33 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$6.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$22$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$21(anon.33 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$22(float x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)x));
            }
            {
                this.c$6 = c$6;
                FromJSON.$init$(this);
                this.fields = c$6.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$21$adapted(anon.33 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.33.$anonfun$read$21($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$22$adapted(Object x) {
                return anon.33.$anonfun$read$22(BoxesRunTime.unboxToFloat((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$21$adapted(io.sphere.json.FromJSON$$anon$33 scala.Tuple2 ), $anonfun$read$22$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<Object>> optionReader$mIc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$7;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$23$adapted(io.sphere.json.FromJSON$$anon$34 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$7.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$24$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$23(anon.34 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$24(int x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x));
            }
            {
                this.c$7 = c$7;
                FromJSON.$init$(this);
                this.fields = c$7.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$23$adapted(anon.34 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.34.$anonfun$read$23($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$24$adapted(Object x) {
                return anon.34.$anonfun$read$24(BoxesRunTime.unboxToInt((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$23$adapted(io.sphere.json.FromJSON$$anon$34 scala.Tuple2 ), $anonfun$read$24$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<Object>> optionReader$mJc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$8;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$25$adapted(io.sphere.json.FromJSON$$anon$35 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$8.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$26$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$25(anon.35 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$26(long x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)x));
            }
            {
                this.c$8 = c$8;
                FromJSON.$init$(this);
                this.fields = c$8.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$25$adapted(anon.35 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.35.$anonfun$read$25($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$26$adapted(Object x) {
                return anon.35.$anonfun$read$26(BoxesRunTime.unboxToLong((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$25$adapted(io.sphere.json.FromJSON$$anon$35 scala.Tuple2 ), $anonfun$read$26$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<Object>> optionReader$mSc$sp(FromJSON<Object> c) {
        return new FromJSON<Option<Object>>(c){
            private final Set<String> fields;
            private final FromJSON c$9;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<Object>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$27$adapted(io.sphere.json.FromJSON$$anon$36 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$9.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$28$adapted(java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$27(anon.36 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$28(short x) {
                return Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)x));
            }
            {
                this.c$9 = c$9;
                FromJSON.$init$(this);
                this.fields = c$9.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$27$adapted(anon.36 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.36.$anonfun$read$27($this, t));
            }

            public static final /* synthetic */ Option $anonfun$read$28$adapted(Object x) {
                return anon.36.$anonfun$read$28(BoxesRunTime.unboxToShort((Object)x));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$27$adapted(io.sphere.json.FromJSON$$anon$36 scala.Tuple2 ), $anonfun$read$28$adapted(java.lang.Object )}, serializedLambda);
            }
        };
    }

    public FromJSON<Option<BoxedUnit>> optionReader$mVc$sp(FromJSON<BoxedUnit> c) {
        return new FromJSON<Option<BoxedUnit>>(c){
            private final Set<String> fields;
            private final FromJSON c$10;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
            }

            /*
             * Unable to fully structure code
             */
            public Validated<NonEmptyList<JSONError>, Option<BoxedUnit>> read(JsonAST.JValue jval) {
                block8: {
                    block7: {
                        block5: {
                            block6: {
                                block4: {
                                    var4_2 = jval;
                                    if (!JsonAST.JNothing$.MODULE$.equals(var4_2)) break block4;
                                    var3_3 = true;
                                    break block5;
                                }
                                if (!JsonAST.JNull$.MODULE$.equals(var4_2)) break block6;
                                var3_3 = true;
                                break block5;
                            }
                            if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                            var5_4 = (JsonAST.JObject)var4_2;
                            var6_5 = var5_4.obj();
                            v0 = scala.package$.MODULE$.Nil();
                            var7_6 = var6_5;
                            if (!(v0 != null ? v0.equals(var7_6) == false : var7_6 != null)) {
                                var3_3 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                var3_3 = false;
                            }
                        }
                        if (!var3_3) break block7;
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                        break block8;
                    }
                    if (!(var4_2 instanceof JsonAST.JObject)) ** GOTO lbl-1000
                    var8_8 = (JsonAST.JObject)var4_2;
                    s = var8_8.obj();
                    if (this.fields().nonEmpty() && s.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$29$adapted(io.sphere.json.FromJSON$$anon$37 scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)(this))) {
                        var2_7 = FromJSON$.MODULE$.io$sphere$json$FromJSON$$validNone();
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_7 = this.c$10.read(var4_2).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$read$30(scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/Option;)());
                    }
                }
                return var2_7;
            }

            public Set<String> fields() {
                return this.fields;
            }

            public static final /* synthetic */ boolean $anonfun$read$29(anon.37 $this, Tuple2 t) {
                return !$this.fields().contains(t._1());
            }

            public static final /* synthetic */ Option $anonfun$read$30(BoxedUnit x) {
                return Option$.MODULE$.apply((Object)x);
            }
            {
                this.c$10 = c$10;
                FromJSON.$init$(this);
                this.fields = c$10.fields();
            }

            public static final /* synthetic */ Object $anonfun$read$29$adapted(anon.37 $this, Tuple2 t) {
                return BoxesRunTime.boxToBoolean((boolean)anon.37.$anonfun$read$29($this, t));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$29$adapted(io.sphere.json.FromJSON$$anon$37 scala.Tuple2 ), $anonfun$read$30(scala.runtime.BoxedUnit )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mZc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$6;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$6.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            boolean s = BoxesRunTime.unboxToBoolean((Object)valid.a());
                            if (!failedOnce$3.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$3.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$6 = r$6;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$31(io.sphere.json.FromJSON$$anon$38 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mBc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$7;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$7.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            byte s = BoxesRunTime.unboxToByte((Object)valid.a());
                            if (!failedOnce$4.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToByte((byte)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$4.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$7 = r$7;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$32(io.sphere.json.FromJSON$$anon$39 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mCc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$8;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$8.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            char s = BoxesRunTime.unboxToChar((Object)valid.a());
                            if (!failedOnce$5.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$5.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$8 = r$8;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$33(io.sphere.json.FromJSON$$anon$40 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mDc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$9;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$9.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            double s = BoxesRunTime.unboxToDouble((Object)valid.a());
                            if (!failedOnce$6.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToDouble((double)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$6.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$9 = r$9;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$34(io.sphere.json.FromJSON$$anon$41 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mFc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$10;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$10.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            float s = BoxesRunTime.unboxToFloat((Object)valid.a());
                            if (!failedOnce$7.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToFloat((float)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$7.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$10 = r$10;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$35(io.sphere.json.FromJSON$$anon$42 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mIc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$11;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$11.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            int s = BoxesRunTime.unboxToInt((Object)valid.a());
                            if (!failedOnce$8.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToInteger((int)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$8.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$11 = r$11;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$36(io.sphere.json.FromJSON$$anon$43 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mJc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$12;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$12.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            long s = BoxesRunTime.unboxToLong((Object)valid.a());
                            if (!failedOnce$9.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToLong((long)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$9.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$12 = r$12;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$37(io.sphere.json.FromJSON$$anon$44 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<Object>> listReader$mSc$sp(FromJSON<Object> r) {
        return new FromJSON<List<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$13;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$13.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            short s = BoxesRunTime.unboxToShort((Object)valid.a());
                            if (!failedOnce$10.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToShort((short)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$10.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$13 = r$13;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$38(io.sphere.json.FromJSON$$anon$45 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<List<BoxedUnit>> listReader$mVc$sp(FromJSON<BoxedUnit> r) {
        return new FromJSON<List<BoxedUnit>>(r){
            private Set<String> fields;
            private final FromJSON r$14;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, List<BoxedUnit>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    ListBuffer valids = new ListBuffer();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$14.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            BoxedUnit s = (BoxedUnit)valid.a();
                            if (!failedOnce$11.elem) {
                                return valids.$plus$eq((Object)s);
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$11.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$14 = r$14;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$39(io.sphere.json.FromJSON$$anon$46 scala.runtime.BooleanRef scala.collection.mutable.ListBuffer scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mZc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$15;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mZc$sp(this.r$15).read(jval);
            }
            {
                this.r$15 = r$15;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mBc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$16;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mBc$sp(this.r$16).read(jval);
            }
            {
                this.r$16 = r$16;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mCc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$17;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mCc$sp(this.r$17).read(jval);
            }
            {
                this.r$17 = r$17;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mDc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$18;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mDc$sp(this.r$18).read(jval);
            }
            {
                this.r$18 = r$18;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mFc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$19;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mFc$sp(this.r$19).read(jval);
            }
            {
                this.r$19 = r$19;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mIc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$20;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mIc$sp(this.r$20).read(jval);
            }
            {
                this.r$20 = r$20;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mJc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$21;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mJc$sp(this.r$21).read(jval);
            }
            {
                this.r$21 = r$21;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<Object>> seqReader$mSc$sp(FromJSON<Object> r) {
        return new FromJSON<Seq<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$22;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<Object>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mSc$sp(this.r$22).read(jval);
            }
            {
                this.r$22 = r$22;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Seq<BoxedUnit>> seqReader$mVc$sp(FromJSON<BoxedUnit> r) {
        return new FromJSON<Seq<BoxedUnit>>(r){
            private Set<String> fields;
            private final FromJSON r$23;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Seq<BoxedUnit>> read(JsonAST.JValue jval) {
                return FromJSON$.MODULE$.listReader$mVc$sp(this.r$23).read(jval);
            }
            {
                this.r$23 = r$23;
                FromJSON.$init$(this);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mZc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$24;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mZc$sp(this.r$24).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$24 = r$24;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$40(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mBc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$25;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mBc$sp(this.r$25).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$25 = r$25;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$41(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mCc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$26;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mCc$sp(this.r$26).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$26 = r$26;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$42(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mDc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$27;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mDc$sp(this.r$27).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$27 = r$27;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$43(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mFc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$28;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mFc$sp(this.r$28).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$28 = r$28;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$44(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mIc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$29;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mIc$sp(this.r$29).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$29 = r$29;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$45(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mJc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$30;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mJc$sp(this.r$30).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$30 = r$30;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$46(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<Object>> setReader$mSc$sp(FromJSON<Object> r) {
        return new FromJSON<Set<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$31;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<Object>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mSc$sp(this.r$31).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$31 = r$31;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$47(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Set<BoxedUnit>> setReader$mVc$sp(FromJSON<BoxedUnit> r) {
        return new FromJSON<Set<BoxedUnit>>(r){
            private Set<String> fields;
            private final FromJSON r$32;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Set<BoxedUnit>> read(JsonAST.JValue jval) {
                JsonAST.JValue jValue = jval;
                Validated validated = jValue instanceof JsonAST.JArray ? FromJSON$.MODULE$.listReader$mVc$sp(this.r$32).read(jval).map((Function1 & Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)x$1)) : this.fail("JSON Array expected.");
                return validated;
            }
            {
                this.r$32 = r$32;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$48(scala.collection.immutable.List )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mZc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$33;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$33.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            boolean s = BoxesRunTime.unboxToBoolean((Object)valid.a());
                            if (!failedOnce$12.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$12.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$33 = r$33;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$49(io.sphere.json.FromJSON$$anon$65 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mBc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$34;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$34.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            byte s = BoxesRunTime.unboxToByte((Object)valid.a());
                            if (!failedOnce$13.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToByte((byte)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$13.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$34 = r$34;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$50(io.sphere.json.FromJSON$$anon$66 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mCc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$35;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$35.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            char s = BoxesRunTime.unboxToChar((Object)valid.a());
                            if (!failedOnce$14.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$14.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$35 = r$35;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$51(io.sphere.json.FromJSON$$anon$67 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mDc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$36;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$36.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            double s = BoxesRunTime.unboxToDouble((Object)valid.a());
                            if (!failedOnce$15.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToDouble((double)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$15.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$36 = r$36;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$52(io.sphere.json.FromJSON$$anon$68 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mFc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$37;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$37.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            float s = BoxesRunTime.unboxToFloat((Object)valid.a());
                            if (!failedOnce$16.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToFloat((float)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$16.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$37 = r$37;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$53(io.sphere.json.FromJSON$$anon$69 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mIc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$38;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$38.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            int s = BoxesRunTime.unboxToInt((Object)valid.a());
                            if (!failedOnce$17.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToInteger((int)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$17.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$38 = r$38;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$54(io.sphere.json.FromJSON$$anon$70 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mJc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$39;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$39.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            long s = BoxesRunTime.unboxToLong((Object)valid.a());
                            if (!failedOnce$18.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToLong((long)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$18.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$39 = r$39;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$55(io.sphere.json.FromJSON$$anon$71 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<Object>> vectorReader$mSc$sp(FromJSON<Object> r) {
        return new FromJSON<Vector<Object>>(r){
            private Set<String> fields;
            private final FromJSON r$40;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<Object>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$40.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            short s = BoxesRunTime.unboxToShort((Object)valid.a());
                            if (!failedOnce$19.elem) {
                                return valids.$plus$eq((Object)BoxesRunTime.boxToShort((short)s));
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$19.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$40 = r$40;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$56(io.sphere.json.FromJSON$$anon$72 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    public FromJSON<Vector<BoxedUnit>> vectorReader$mVc$sp(FromJSON<BoxedUnit> r) {
        return new FromJSON<Vector<BoxedUnit>>(r){
            private Set<String> fields;
            private final FromJSON r$41;

            public final Validated.Invalid<NonEmptyList<JSONError>> fail(String msg) {
                return FromJSON.fail$(this, msg);
            }

            public Set<String> fields() {
                return this.fields;
            }

            public void io$sphere$json$FromJSON$_setter_$fields_$eq(Set<String> x$1) {
                this.fields = x$1;
            }

            public Validated<NonEmptyList<JSONError>, Vector<BoxedUnit>> read(JsonAST.JValue jval2) {
                Validated.Valid valid;
                JsonAST.JValue jValue = jval2;
                if (jValue instanceof JsonAST.JArray) {
                    JsonAST.JArray jArray = (JsonAST.JArray)jValue;
                    List l = jArray.arr();
                    ListBuffer errors = new ListBuffer();
                    VectorBuilder valids = new VectorBuilder();
                    BooleanRef failedOnce = BooleanRef.create((boolean)false);
                    l.foreach((Function1 & Serializable)jval -> {
                        Validated<NonEmptyList<JSONError>, A> validated = $this.r$41.read((JsonAST.JValue)jval);
                        if (validated instanceof Validated.Valid) {
                            Validated.Valid valid = (Validated.Valid)validated;
                            BoxedUnit s = (BoxedUnit)valid.a();
                            if (!failedOnce$20.elem) {
                                return valids.$plus$eq((Object)s);
                            }
                        }
                        if (!(validated instanceof Validated.Invalid)) return BoxedUnit.UNIT;
                        Validated.Invalid invalid = (Validated.Invalid)validated;
                        NonEmptyList nel = (NonEmptyList)invalid.e();
                        errors.$plus$plus$eq((IterableOnce)nel.toList());
                        failedOnce$20.elem = true;
                        return BoxedUnit.UNIT;
                    });
                    valid = errors.isEmpty() ? new Validated.Valid((Object)valids.result()) : new Validated.Invalid((Object)NonEmptyList$.MODULE$.fromListUnsafe(errors.result()));
                } else {
                    valid = this.fail("JSON Array expected.");
                }
                return valid;
            }
            {
                this.r$41 = r$41;
                FromJSON.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$read$57(io.sphere.json.FromJSON$$anon$73 scala.runtime.BooleanRef scala.collection.immutable.VectorBuilder scala.collection.mutable.ListBuffer org.json4s.JsonAST$JValue )}, serializedLambda);
            }
        };
    }

    private FromJSON$() {
    }
}

